package com.mmc.iuav.user.service.impl;

import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.dao.MessageDao;
import com.mmc.iuav.user.entity.SystemMessageDO;
import com.mmc.iuav.user.model.qo.MessageQO;
import com.mmc.iuav.user.model.vo.SystemMessageVO;
import com.mmc.iuav.user.service.MessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class MessageServiceImpl implements MessageService {

    @Autowired
    private MessageDao messageDao;
    @Override
    public ResultBody insertSystemMessage(SystemMessageVO messageVO) {
        SystemMessageDO systemMessageDO = new SystemMessageDO(messageVO);
        if(messageDao.insertSystemMessage(systemMessageDO) != 0){
            return ResultBody.success("消息发布成功");
        }
        return ResultBody.error("消息发布失败");
    }

    @Override
    public ResultBody selectSystemMessageById(Integer id) {
        return ResultBody.success(messageDao.selectSystemMessageById(id));
    }

    @Override
    public PageResult selectAllSystemMessage(MessageQO messageQO) {
        int count = messageDao.countSystemMessage();
        if (count == 0) {
            return PageResult.buildPage(messageQO.getPageNo(), messageQO.getPageSize(), count);
        }
        Integer pageNo = messageQO.getPageNo();
        messageQO.buildCurrentPage();
        List<SystemMessageDO> messageList = messageDao.selectAllSystemMessage(messageQO);
        return PageResult.buildPage(pageNo, messageQO.getPageSize(), count, messageList);
    }
    @Override
    public ResultBody removeMessage(Integer id) {
        if(messageDao.removeMessage(id) != 0){
            messageDao.removeReceiverMessageByMessageId(id);
            return ResultBody.success("删除成功");
        }
        return ResultBody.error("删除失败");
    }
    @Override
    public PageResult selectAllSystemMessageByReceive(Integer userId, MessageQO messageQO) {
        if(userId == null){
            ResultBody.error("未登录");
        }
        int count = messageDao.countSystemMessage();
        if (count == 0) {
            return PageResult.buildPage(messageQO.getPageNo(), messageQO.getPageSize(), count);
        }
        Integer pageNo = messageQO.getPageNo();
        messageQO.buildCurrentPage();
        List<SystemMessageDO> messagesDO = new ArrayList<>();
        List<SystemMessageDO> messages = messageDao.selectAllSystemMessage(messageQO);
        for (SystemMessageDO message : messages) {
            if(messageDao.selectReceiverMessage(userId, message.getId()) != 0){
                // 已读
                message.setRead(true);
            }
            // 读过但是已经删除
            if(messageDao.selectReceiverMessageByDel(userId, message.getId()) != 0){
                continue;
            }
            messagesDO.add(message);
        }
        return PageResult.buildPage(pageNo, messageQO.getPageSize(), count, messagesDO);
    }

    @Override
    public ResultBody showSystemMessageByUser(Integer userId, Integer messageId) {
        if(userId == null){
            ResultBody.error("未登录");
        }
        SystemMessageDO message = messageDao.selectSystemMessageById(messageId);
        if(message == null){
            return ResultBody.success(message);
        }
        //没有读过,查看之后标为已读
        if(messageDao.selectReceiverMessage(userId, messageId) == 0){
            messageDao.insertReceiverMessage(userId,messageId);
        }
        message.setRead(true);
        // 读过但是已经删除
        if(messageDao.selectReceiverMessageByDel(userId, message.getId()) != 0){
            message = null;
        }
        return ResultBody.success(message);
    }

    @Override
    public ResultBody removeMessageByUser(Integer userId, Integer messageId) {
        if(messageDao.removeReceiverMessage(userId, messageId) != 0){
            return ResultBody.success("删除成功");
        }
        return ResultBody.error("删除失败");
    }

}
