package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.RealNameAuthDTO;
import com.mmc.iuav.user.model.qo.RealNameAuthQO;
import com.mmc.iuav.user.model.vo.RealNameAuthVO;
import com.mmc.iuav.user.service.RealNameAuthService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/7/27 10:04
 */
@Api(tags = "实名认证")
@RequestMapping("/real-name-auth/")
@RestController
public class RealNameAuthController extends BaseController {
    @Autowired
    private RealNameAuthService realNameAuthService;

    @ApiOperation(value = "提交实名认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("add")
    public ResultBody add(@Validated(value = {Create.class}) @RequestBody RealNameAuthVO realNameAuthVO) {
        return realNameAuthService.add(realNameAuthVO);
    }

    @ApiOperation(value = "实名认证详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RealNameAuthDTO.class)})
    @GetMapping("detail")
    public ResultBody<RealNameAuthDTO> detail(@RequestParam Integer id) {
        return realNameAuthService.detail(id);
    }

    @ApiOperation(value = "用户实名认证详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RealNameAuthDTO.class)})
    @GetMapping("userDetail")
    public ResultBody<RealNameAuthDTO> userDetail(HttpServletRequest request) {
        return realNameAuthService.userDetail(this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "实名认证列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("listPage")
    public ResultBody listPage(@RequestBody RealNameAuthQO realNameAuthQO) {
        return realNameAuthService.listPage(realNameAuthQO);
    }
}
