package com.mmc.iuav.user.schedule;

import com.mmc.iuav.user.model.vo.data.ActiveUserCountVO;
import com.mmc.iuav.user.service.data.UserReportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;

/**
 * @author lw
 */
@Component
@ConditionalOnProperty(prefix = "scheduling", name = "enabled", havingValue = "true")
@Slf4j
public class ManagerLogSchedule {
    @Resource
    UserReportService userReportService;

    /**
     * 统计日活量
     */
    @Scheduled(cron = "0 0 8 * * ?")
    public void calculateActiveUserCount() {
        log.info("统计日活量");
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        //记录到数据库
        ActiveUserCountVO yxfActiveUserCountVO = new ActiveUserCountVO();
        yxfActiveUserCountVO.setActiveDate(calendar.getTime());
        int temp = 0,i=0;
        while(temp == 0 && i <= 5) {
            Integer userActiveCount = userReportService.getUserActiveCount();
            if(userActiveCount != null) {
                yxfActiveUserCountVO.setActiveUserCount(userActiveCount);
                temp = userReportService.insertActiveUserCount(yxfActiveUserCountVO);
            }
            i++;
        }
    }

}