package com.mmc.iuav.user.model.vo;

import com.mmc.iuav.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.security.PrivateKey;
import java.util.Set;

/**
 * @author: zj
 * @Date: 2023/6/28 15:59
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserCooperationTagVO implements Serializable {
    private static final long serialVersionUID = 7899913481538765762L;
    @ApiModelProperty(value = "用户id")
    @NotNull(message = "用户id不能为空",groups = {Update.class})
    private Integer userAccountId;
    @ApiModelProperty(value = "合作标签id")
    private Set<Integer> cooperationTagIds;
}
