package com.mmc.iuav.user.service.dronepilot.impl;

import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import com.mmc.iuav.user.dao.dronepilot.PilotCertificationDao;
import com.mmc.iuav.user.entity.dronepilot.CertificationMessage;
import com.mmc.iuav.user.entity.dronepilot.PilotAbilityDO;
import com.mmc.iuav.user.entity.dronepilot.PilotCertificationDO;
import com.mmc.iuav.user.entity.dronepilot.PilotCertificationLogDO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.dto.dronepilot.PilotAbilityDTO;
import com.mmc.iuav.user.model.dto.dronepilot.PilotCertificationDTO;
import com.mmc.iuav.user.model.qo.dronepilot.PilotCertificationQO;
import com.mmc.iuav.user.model.vo.dronepilot.PilotAbilityVO;
import com.mmc.iuav.user.model.vo.dronepilot.PilotCertificationVO;
import com.mmc.iuav.user.service.dronepilot.PilotCertificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/7/28 9:35
 * @Version 1.0
 */
@Service
public class PilotCertificationServiceImpl implements PilotCertificationService {

    @Autowired
    private PilotCertificationDao certificationDao;

    @Override
    public ResultBody insertPilot(PilotCertificationVO certificationVO, LoginSuccessDTO userLoginInfoFromRedis) {

        Integer count = certificationDao.selectRealNameAuth(userLoginInfoFromRedis.getUserAccountId());
        if (count == 0) {
            return ResultBody.error(ResultEnum.PLEASE_ERFORM_REAL_NAME_AUTHENTICATION_FIRST);
        }
        Integer integer = certificationDao.selectPilotCertification(userLoginInfoFromRedis.getUserAccountId());
        if (integer != 0) {
            return ResultBody.error(ResultEnum.I_HAVE_APPLIED_FOR_A_PILOT_LICENSE);
        }
        PilotCertificationDO pilotCertificationDO = new PilotCertificationDO(certificationVO, userLoginInfoFromRedis.getUserAccountId());
        certificationDao.insertPilot(pilotCertificationDO);
        List<PilotAbilityVO> pilotAbility = pilotCertificationDO.getPilotAbility();
        for (PilotAbilityVO pilotAbilityVO : pilotAbility) {
            pilotAbilityVO.setPilotCertificationId(pilotCertificationDO.getId());
        }
        certificationDao.insertAbility(pilotAbility);
        PilotCertificationLogDO pilotCertificationLog = new PilotCertificationLogDO(pilotCertificationDO, CertificationMessage.match(0));
        certificationDao.insertPilotLog(pilotCertificationLog);
        return ResultBody.success();
    }

    @Override
    public ResultBody<PilotAbilityDTO> abilityList() {
        List<PilotAbilityDO> abilityDOList = certificationDao.abilityList();
        List<PilotAbilityDTO> collect = abilityDOList.stream().map(PilotAbilityDO::buildPilotAbilityDTO).collect(Collectors.toList());
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody updatePilot(PilotCertificationVO certificationVO, LoginSuccessDTO userLoginInfoFromRedis) {
        certificationDao.deleteAbility(certificationVO.getId());
        PilotCertificationDO pilotCertificationDO = new PilotCertificationDO(certificationVO, userLoginInfoFromRedis.getUserAccountId());
        Integer count = certificationDao.selectPilotCount(pilotCertificationDO.getId(), userLoginInfoFromRedis.getUserAccountId());
        if (count == 0) {
            return ResultBody.error(ResultEnum.CAN_NOT_CHANGE_THE_APPLICATION_OF_OTHERS);
        }
        certificationDao.updatePilot(pilotCertificationDO);
        List<PilotAbilityVO> pilotAbility = pilotCertificationDO.getPilotAbility();
        for (PilotAbilityVO pilotAbilityVO : pilotAbility) {
            pilotAbilityVO.setPilotCertificationId(pilotCertificationDO.getId());
        }
        certificationDao.insertAbility(pilotAbility);
        PilotCertificationLogDO pilotCertificationLog = new PilotCertificationLogDO(pilotCertificationDO, CertificationMessage.match(0));
        certificationDao.insertPilotLog(pilotCertificationLog);
        return ResultBody.success();
    }

    @Override
    public PageResult pilotList(PilotCertificationQO param, LoginSuccessDTO userLoginInfoFromRedis) {
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<PilotCertificationDO> pilotCertificationDOS = certificationDao.pilotList(param);
        extracted(pilotCertificationDOS);
        List<PilotCertificationDTO> collect = pilotCertificationDOS.stream().map(PilotCertificationDO::buildPilotCertificationDTO).collect(Collectors.toList());
        if (param.getAbilityId() != null) {
            for (PilotCertificationDTO pilotCertificationDTO : collect) {
                ArrayList<PilotAbilityVO> list = new ArrayList<>();
                List<PilotAbilityVO> pilotAbility = pilotCertificationDTO.getPilotAbility();
                for (PilotAbilityVO pilotAbilityVO : pilotAbility) {
                    if (pilotAbilityVO.getAbilityId().equals(param.getAbilityId())) {
                        list.add(pilotAbilityVO);
                    }
                }
                if (list.size() == 0) {
                    pilotCertificationDTO.setPilotAbility(null);
                }
            }
            collect = collect.stream().filter(t -> t.getPilotAbility() != null).collect(Collectors.toList());
        }
        PageResult pageResult = PageResult.buildPage(pageNo, param.getPageSize(), collect.size(), collect);
        return pageResult;
    }

    /**
     * 工作年限的计算/年龄
     *
     * @param pilotCertificationDOS
     */
    private void extracted(List<PilotCertificationDO> pilotCertificationDOS) {
        int ageByBirth = 0;
        int yearsOfWorking = 0;
        for (PilotCertificationDO pilotCertificationDO : pilotCertificationDOS) {
            Date birthday = pilotCertificationDO.getBirthday();
            ageByBirth = getAgeByBirth(birthday);
            pilotCertificationDO.setAge(ageByBirth);
            yearsOfWorking = getYearsOfWorking(pilotCertificationDO.getTimeOfApplication());
            Integer Working = pilotCertificationDO.getYearsOfWorking();
            yearsOfWorking = yearsOfWorking + Working;
            pilotCertificationDO.setYearsOfWorking(yearsOfWorking);
        }
    }


    public static int getYearsOfWorking(Date yearsOfWorking) {
        //获取当前时间
        Calendar cal = Calendar.getInstance();
        //获取出生日期的Calendar对象
        Calendar bir = Calendar.getInstance();
        bir.setTime(yearsOfWorking);
        //如果出生日期大于当前日期，则返回0
        if (cal.before(yearsOfWorking)) {
            return 0;
        }
        //取出当前年月日
        int nowYear = cal.get(Calendar.YEAR);
        int nowMonth = cal.get(Calendar.MONTH);
        int nowDay = cal.get(Calendar.DAY_OF_MONTH);

        //取出出生日期的年月日
        int birthYear = bir.get(Calendar.YEAR);
        int birthMonth = bir.get(Calendar.MONTH);
        int birthDay = bir.get(Calendar.DAY_OF_MONTH);

        //计算年份
        int age = nowYear - birthYear;

        //计算月份和日，看看是否大于当前月日，如果小于则减去一岁
        if (nowMonth < birthMonth || (nowMonth == birthMonth && nowDay < birthDay)) {
            age--;
        }
        return age;
    }

    public static int getAgeByBirth(Date birthday) {
        //获取当前时间
        Calendar cal = Calendar.getInstance();
        //获取出生日期的Calendar对象
        Calendar bir = Calendar.getInstance();
        bir.setTime(birthday);
        //如果出生日期大于当前日期，则返回0
        if (cal.before(birthday)) {
            return 0;
        }
        //取出当前年月日
        int nowYear = cal.get(Calendar.YEAR);
        int nowMonth = cal.get(Calendar.MONTH);
        int nowDay = cal.get(Calendar.DAY_OF_MONTH);

        //取出出生日期的年月日
        int birthYear = bir.get(Calendar.YEAR);
        int birthMonth = bir.get(Calendar.MONTH);
        int birthDay = bir.get(Calendar.DAY_OF_MONTH);

        //计算年份
        int age = nowYear - birthYear;

        //计算月份和日，看看是否大于当前月日，如果小于则减去一岁
        if (nowMonth < birthMonth || (nowMonth == birthMonth && nowDay < birthDay)) {
            age--;
        }
        return age;
    }


}
