package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.vo.ApplyTagEditVO;
import com.mmc.iuav.user.model.vo.AttachmentVO;
import com.mmc.iuav.user.model.vo.UserApplyTagVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: zj @Date: 2023/5/17 21:59
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserApplyTagDO implements Serializable {
    private static final long serialVersionUID = -7581203992821286124L;
    private Integer id;
    private Integer cooperationTagId;
    private Integer userAccountId;
    private String applyName;
    private String applyPhone;
    private String remark;
    private Date createTime;
    private Integer applyStatus;
    private String content;
    private Integer score;
    @ApiModelProperty(value = "企业认证id")
    private Integer companyInfoId;

    /**
     * 辅助字段start
     */
    private String tagName;
    private String companyName;
    private String address;
    private String name;
    private Double lat;
    private Double lon;
    @ApiModelProperty(value = "品牌名称", example = "科比特")
    private String brandName;

    @ApiModelProperty(value = "品牌logo", example = "http://")
    private String brandLogo;

    @ApiModelProperty(value = "营业执照", example = "http://")
    private String licenseImg;
    @ApiModelProperty(value = "附件", example = "http://")
    private List<AttachmentVO> attachmentList;

    /**
     * 辅助字段end
     */
    public UserApplyTagVO buildUserApplyTagVO() {
        return UserApplyTagVO.builder()
                .id(id)
                .cooperationTagId(cooperationTagId)
                .userAccountId(this.userAccountId)
                .applyName(this.applyName)
                .applyPhone(this.applyPhone)
                .remark(this.remark)
                .applyTime(createTime)
                .approvalStatus(applyStatus)
                .cooperationTagName(tagName)
                .companyName(companyName)
                .content(content)
                .score(score)
                .brandName(this.brandName)
                .brandLogo(this.brandLogo)
                .licenseImg(this.licenseImg)
                .attachmentList(this.attachmentList)
                .address(this.address)
                .lat(this.lat)
                .lon(this.lon)
                .build();
    }

    public UserApplyTagDO(UserApplyTagVO userApplyTagVO) {
        this.cooperationTagId = userApplyTagVO.getCooperationTagId();
        this.userAccountId = userApplyTagVO.getUserAccountId();
        this.applyName = userApplyTagVO.getApplyName();
        this.applyPhone = userApplyTagVO.getApplyPhone();
        this.remark = userApplyTagVO.getRemark();
        this.brandLogo = userApplyTagVO.getBrandLogo();
        this.brandName = userApplyTagVO.getBrandName();
        this.address = userApplyTagVO.getAddress();
        this.lon = userApplyTagVO.getLon();
        this.lat = userApplyTagVO.getLat();
    }

    public ApplyTagEditVO buildApplyTagEditVO() {
        return ApplyTagEditVO.builder().id(id)
                .cooperationTagId(cooperationTagId).name(name)
                .address(address).lat(lat).lon(lon)
                .content(content).score(score)
                .build();
    }
}
