package com.mmc.iuav.user.controller.dronepilot;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Page;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.dto.RoleInfoDTO;
import com.mmc.iuav.user.model.dto.dronepilot.PilotAbilityDTO;
import com.mmc.iuav.user.model.dto.dronepilot.PilotCertificationDTO;
import com.mmc.iuav.user.model.qo.dronepilot.PilotCertificationQO;
import com.mmc.iuav.user.model.vo.dronepilot.PilotCertificationVO;
import com.mmc.iuav.user.service.dronepilot.PilotCertificationService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author small
 * @Date 2023/7/28 9:32
 * @Version 1.0
 */
@Api(tags = "飞手执照能力及认证")
@RequestMapping("/pilot")
@RestController
public class PilotCertificationController extends BaseController {

    @Autowired
    private PilotCertificationService certificationService;

    @ApiOperation(value = "能力类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RoleInfoDTO.class)})
    @GetMapping("/abilityList")
    public ResultBody<PilotAbilityDTO> abilityList(HttpServletRequest request) {
        return certificationService.abilityList();
    }


    @ApiOperation(value = "小程序——申请——飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/insertPilot")
    public ResultBody insertPilot(HttpServletRequest request, @RequestBody @Validated(value = {Create.class}) PilotCertificationVO certificationVO) {
        return certificationService.insertPilot(certificationVO, this.getUserLoginInfoFromRedis(request));
    }


    @ApiOperation(value = "小程序——编辑——飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/updatePilot")
    public ResultBody updatePilot(HttpServletRequest request, @RequestBody @Validated(value = {Update.class}) PilotCertificationVO certificationVO) {
        return certificationService.updatePilot(certificationVO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "小程序——列表————飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @PostMapping("/detailPilot")
    public ResultBody<PilotCertificationDTO> pilotList(HttpServletRequest request,
                                                       @Validated(value = {Page.class}) @ApiParam(value = "飞手查询", required = true) @RequestBody PilotCertificationQO param) {
        return ResultBody.success(certificationService.pilotList(param, this.getUserLoginInfoFromRedis(request)));
    }

    
}
