package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.CompanyBackUserDO;
import com.mmc.iuav.user.entity.CompanyInfoDO;
import com.mmc.iuav.user.entity.CompanyMemberDO;
import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.model.qo.CompanyInfoQO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/7/3 15:39
 */
@Mapper
public interface CompanyDao {
    /**
     * 添加单位
     *
     * @param companyInfoDO
     */
    void addCompanyInfo(CompanyInfoDO companyInfoDO);

    /**
     * 移除单位
     *
     * @param id
     */
    void removeCompanyInfo(Integer id);

    /**
     * 修改单位
     *
     * @param companyInfoDO
     */
    void updateCompanyInfo(CompanyInfoDO companyInfoDO);

    /**
     * 单位查询
     *
     * @param id
     * @return
     */
    CompanyInfoDO getCompanyInfoById(Integer id);

    /**
     * 单位数量查询
     *
     * @param param
     * @return
     */
    int countListCompanyPage(CompanyInfoQO param);

    /**
     * 单位列表
     *
     * @param param
     * @return
     */
    List<CompanyInfoDO> listCompanyPage(CompanyInfoQO param);

    /**
     * 通过用户ID获取单位信息 小程序
     *
     * @param backUserAccountId
     * @return
     */
    CompanyInfoDO getCompanyInfoByBackUserAccountId(Integer backUserAccountId);
    /**
     * 通过用户ID获取单位信息 后台管理
     *
     * @param backUserAccountId
     * @return
     */
    CompanyInfoDO getCompanyInfoByAppLoginUserId(Integer backUserAccountId);


    /**
     * 添加绑定关系
     *
     * @param companyBackUserDO
     */
    void addCompanyBackUser(CompanyBackUserDO companyBackUserDO);

    /**
     * 修改绑定关系
     *
     * @param companyBackUserDO
     */
    void updateCompanyBackUser(CompanyBackUserDO companyBackUserDO);

    /**
     * 查询单位绑定的账号数量
     *
     * @param id
     * @return
     */
    int countCompanyBackUser(Integer id);

    /**
     * 通过用户id获取单位信息
     *
     * @param backUserIds
     * @return
     */
    List<CompanyInfoDO> listCompanyInfoByUID(@Param("backUserIds") List<Integer> backUserIds);

    /**
     * 查询同名单位个数
     *
     * @param id
     * @param companyName
     * @return
     */
    int countCompanyNames(Integer id, String companyName);

    /**
     * 通过单位名称查询单位信息
     *
     * @param companyName
     * @return
     */
    CompanyInfoDO getCompanyInfoByName(String companyName);

    /**
     * 企业绑定的成员
     *
     * @param companyInfoId
     * @return
     */
    List<CompanyMemberDO> listCompanyMembers(Integer companyInfoId);

    /**
     * 绑定成员
     *
     * @param companyMemberDO
     */
    void addCompanyMember(CompanyMemberDO companyMemberDO);

    /**
     * 小程序获取绑定企业信息
     *
     * @param userAccountId
     * @return
     */
    CompanyInfoDO getAppCompanyInfoUId(Integer userAccountId);

    /**
     * 获取公司绑定的后台用户id
     *
     * @param id
     * @return
     */
    CompanyBackUserDO getCompanyBackUserByCompanyId(Integer id);

    /**
     * 获取绑定关系
     *
     * @param userAccountId
     * @param companyInfoId
     * @return
     */
    CompanyMemberDO getCompanyMember(Integer userAccountId, Integer companyInfoId);

    /**
     * 解绑单位成员
     *
     * @param userAccountId
     * @param companyInfoId
     */
    void unbindCompanyMember(Integer userAccountId, Integer companyInfoId);


    /**
     * 修改单位管理员状态
     *
     * @param fromUserAccountId
     * @param i
     * @param companyInfoId
     */
    void updateCompanyMember(Integer fromUserAccountId, Integer i, Integer companyInfoId);

    /**
     * 公司绑定成员个数
     *
     * @param id
     * @return
     */
    int countCompanyMembers(Integer id);

    /**
     * 单位成员列表-分页
     *
     * @param id
     * @param pageNo
     * @param pageSize
     * @return
     */
    List<UserAccountDO> listCompanyMembersPage(Integer id, Integer pageNo, Integer pageSize);

    int countBingingCompanyInfoByUID(Integer userAccountId);

    void unbindingAllAppUsers(Integer id);

    void unbindingAllPcUsers(Integer id);

    List<CompanyInfoDO> listCompanyInfoByIds(@Param("ids") List<Integer> ids);

    void deleteCompanyInfoById(Integer id);

    CompanyMemberDO getManagerByCompanyId(Integer companyInfoId);

    CompanyBackUserDO getCompanyBackUserByBackUserId(Integer backUserAccountId);

    /**
     * 从旧版云享飞搜索添加到新版云享飞
     * @param userId 被邀请人
     * @param rUserId 邀请人
     */
    void insertUserRcd(Integer userId,Integer rUserId);

    Integer selectUserByUserRcd(Integer userId);
}
