package com.mmc.iuav.user.model.vo.dronepilot;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.user.model.dto.dronepilot.LicenseType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * @Author small
 * @Date 2023/7/28 10:02
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel
public class PilotCertificationVO {
    @ApiModelProperty(value = "飞手执照id", example = "1")
    @NotNull(message = "飞手执照id不能为空", groups = Update.class)
    private Integer id;


    @ApiModelProperty(value = "执照类型 CAAC,UTC,OTHER(其他) 目前只有三种", example = "UTC", required = true)
    @NotNull(message = "执照类型不能为空", groups = {Create.class, Update.class})
    @EnumValue(enumClass = LicenseType.class, message = "取值不合法,参考:LicenseType")
    private String licenseType;


    @ApiModelProperty(value = "电子执照的编号", example = "231321312313211", required = true)
    @NotBlank(message = "电子执照的编号不能为空", groups = {Create.class, Update.class})
    private String licenseNumber;

    @ApiModelProperty(value = "上传执照", example = "http://share-fly.oss-cn-hangzhou.aliyuncs.com/file/2cbbeffb-c1d1-4b26-a9a9-9e17c85e35a9.jpg", required = true)
    @NotBlank(message = "上传执照的照片不能为空", groups = {Create.class, Update.class})
    private String licenseUrl;

    @ApiModelProperty(value = "地区编号不能为空", example = "100001", required = true)
    @NotNull(message = "地区编号不能为空", groups = {Create.class, Update.class})
    private Integer areaNumber;

    @ApiModelProperty(value = "常驻城市不能为空", example = "深圳市", required = true)
    @NotBlank(message = "常驻城市不能为空", groups = {Create.class, Update.class})
    private String residentCity;

    @ApiModelProperty(value = "工作年限", example = "3", required = true)
    @NotNull(message = "工作年限不能为空", groups = {Create.class, Update.class})
    @Max(value = 80, message = "工作年限不能超过80年")
    private Integer yearsOfWorking;

    @NotNull(message = "能力不能为空", groups = {Create.class, Update.class})
    List<PilotAbilityVO> pilotAbility;

    @ApiModelProperty(value = "能力不能为空", example = "http://share-fly.oss-cn-hangzhou.aliyuncs.com/file/2cbbeffb-c1d1-4b26-a9a9-9e17c85e35a9.jpg", required = true)
    @NotBlank(message = "能力图片不能为空", groups = {Create.class, Update.class})
    private String abilityUrl;

    @ApiModelProperty(value = "个人简介", example = "无人机专业，工作三年", required = true)
    @NotBlank(message = "个人简介不能为空", groups = {Create.class, Update.class})
    @Size(max = 300, message = "个人不能超过300")
    private String individualResume;

    @ApiModelProperty(value = "备注", example = "航拍摄影,农业植保", required = false)
    private String remark;

    @ApiModelProperty(value = "审核是否通过 0审核中 1审核通过 2审核不通过", example = "0", required = false)
    private Integer auditStatus;

    @ApiModelProperty(value = "飞手简历")
    private String pilotResume;
}
