package com.mmc.iuav.user.service.userpoints;

import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.qo.userpoints.AppPointsDetailsQO;
import com.mmc.iuav.user.model.qo.userpoints.UserPointQO;
import com.mmc.iuav.user.model.qo.userpoints.UserPointsDetailsQO;
import com.mmc.iuav.user.model.vo.userpoints.ChangeUserPointVO;

/**
 * @Author small
 * @Date 2023/8/5 16:31
 * @Version 1.0
 */
public interface UserPointsService {
    PageResult userPointList(UserPointQO param);

    PageResult detailPoint(UserPointsDetailsQO param);

    PageResult appDetailPoint(Integer userAccountId, AppPointsDetailsQO param);

    ResultBody change(ChangeUserPointVO changePoint);

    ResultBody listChangeType();


    /**
     * 改变用户积分，一种是前端传用户userid和扣除积分的pointChangeTypeId（数据库查找变动积分多少和积分变更原因）
     * 另一种是供别的服务使用 直接传入用户userid和变动多少积分changePoint和变动原因
     * @param userId 用户id
     * @param pointChangeTypeId 根据这个id去user_points_change_type表中查找需要修改多少积分和原因
     * @param changePoint 修改多少积分
     * @return {@link ResultBody}
     */
    ResultBody changeUserPoints(Integer userId,Integer pointChangeTypeId,int changePoint,String reason);

}
