package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.entity.fdd.ContractInfoDO;
import com.mmc.iuav.user.model.vo.ApplyTagEditVO;
import com.mmc.iuav.user.model.vo.AttachmentVO;
import com.mmc.iuav.user.model.vo.UserApplyTagVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: zj @Date: 2023/5/17 21:59
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class  UserApplyTagDO implements Serializable {
    private static final long serialVersionUID = -7581203992821286124L;
    private Integer id;
    private Integer cooperationTagId;
    private Integer userAccountId;
    private String applyName;
    private String applyPhone;
    private String remark;
    private Date createTime;
    private Integer applyStatus;
    private String orderNo;
    private Integer signStatus;
    private String contractNo;
    /**
     * 辅助字段start
     */
    @ApiModelProperty(value = "申请品牌")
    private String tagName;
    @ApiModelProperty(value = "用户认证企业")
    private CompanyInfoDO companyInfoDO;
    @ApiModelProperty(value = "附件", example = "http://")
    private List<AttachmentVO> attachmentList;
    @ApiModelProperty(value = "后台账号id" )
    private Integer backUserId;

    /**
     * 辅助字段end
     */
    public UserApplyTagVO buildUserApplyTagVO() {
        return UserApplyTagVO.builder()
                .id(id)
                .cooperationTagId(cooperationTagId)
                .userAccountId(this.userAccountId)
                .applyName(this.applyName)
                .applyPhone(this.applyPhone)
                .remark(this.remark)
                .applyTime(createTime)
                .orderNo(orderNo)
                .backUserId(this.backUserId)
                .approvalStatus(applyStatus)
                .cooperationTagName(tagName)
                .signStatus(signStatus)
                .attachmentList(this.attachmentList)
                .content(this.companyInfoDO == null ? null : this.companyInfoDO.getContent())
                .score(this.companyInfoDO == null ? null : this.companyInfoDO.getScore())
                .companyName(this.companyInfoDO == null ? null : this.companyInfoDO.getCompanyName())
                .brandName(this.companyInfoDO == null ? null : this.companyInfoDO.getBrandName())
                .brandLogo(this.companyInfoDO == null ? null : this.companyInfoDO.getBrandLogo())
                .licenseImg(this.companyInfoDO == null ? null : this.companyInfoDO.getLicenseImg())
                .address(this.companyInfoDO == null ? null : this.companyInfoDO.getAddress())
                .lat(this.companyInfoDO == null ? null : this.companyInfoDO.getLat())
                .lon(this.companyInfoDO == null ? null : this.companyInfoDO.getLon())
                .build();
    }

    public UserApplyTagDO(UserApplyTagVO userApplyTagVO) {
        this.cooperationTagId = userApplyTagVO.getCooperationTagId();
        this.userAccountId = userApplyTagVO.getUserAccountId();
        this.applyName = userApplyTagVO.getApplyName();
        this.applyPhone = userApplyTagVO.getApplyPhone();
        this.remark = userApplyTagVO.getRemark();
    }

    public ApplyTagEditVO buildApplyTagEditVO() {
        return ApplyTagEditVO.builder().id(id)
                .cooperationTagId(cooperationTagId).name(this.companyInfoDO == null ? null : this.companyInfoDO.getCompanyName())
                .address(this.companyInfoDO == null ? null : this.companyInfoDO.getAddress())
                .lat(this.companyInfoDO == null ? null : this.companyInfoDO.getLat())
                .lon(this.companyInfoDO == null ? null : this.companyInfoDO.getLon())
                .content(this.companyInfoDO == null ? null : this.companyInfoDO.getContent())
                .score(this.companyInfoDO == null ? null : this.companyInfoDO.getScore())
                .attachmentList(this.attachmentList)
                .content(this.companyInfoDO == null ? null : this.companyInfoDO.getContent())
                .score(this.companyInfoDO == null ? null : this.companyInfoDO.getScore())
                .companyName(this.companyInfoDO == null ? null : this.companyInfoDO.getCompanyName())
                .brandName(this.companyInfoDO == null ? null : this.companyInfoDO.getBrandName())
                .brandLogo(this.companyInfoDO == null ? null : this.companyInfoDO.getBrandLogo())
                .licenseImg(this.companyInfoDO == null ? null : this.companyInfoDO.getLicenseImg())
                .address(this.companyInfoDO == null ? null : this.companyInfoDO.getAddress())
                .lat(this.companyInfoDO == null ? null : this.companyInfoDO.getLat())
                .lon(this.companyInfoDO == null ? null : this.companyInfoDO.getLon())
                .contractNo(contractNo)
                .remark(this.remark)
                .signStatus(signStatus)
                .build();
    }
}
