package com.mmc.iuav.user.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author LW
 * @date 2023/8/26 15:42
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class WithdrawalInfoVO implements Serializable {
    public final static String AMT = "amt";
    public final static String APPLY = "APPLY";
    private static final long serialVersionUID = 2535626170303302278L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "流水编号")
    private String payNo;
    @ApiModelProperty(value = "操作方式")
    private Integer payMethod;
    @ApiModelProperty(value = "佣金变动金额(正数入账，负数扣除)")
    private BigDecimal salaryAmtPaid;
    @ApiModelProperty(value = "操作时间")
    private Date payTime;
    @ApiModelProperty(value = "操作名称")
    private String name;
}
