package com.mmc.iuav.user.service;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.vo.WxLoginVO;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author: zj
 * @Date: 2023/5/16 13:43
 */
public interface WxService {
    /**
     * 小程序登录调用接口
     * @param wxLoginVO
     * @return
     */
    String appLogin(WxLoginVO wxLoginVO);

    /**
     * pc扫码登录
     * @param wxLoginVO
     * @return
     */
    String pcLogin(WxLoginVO wxLoginVO);

    /**
     * 获取AccessToken
     * @return
     */
    String getAccessToken();

    /**
     * 获取公众号AccessToken
     * @return
     */
    String getSubAccessToken();

    /**
     * 监控微信公众号的事件变化通知
     * @param request
     * @param response
     */
    void receiveSubAccountEvents(HttpServletRequest request, HttpServletResponse response);

    /**
     * 推送订阅消息
     * @return
     */
    ResultBody sendSubMsg();



    /**
     * 获取不限制的小程序码
     * @param path
     * @param scene
     */
    void getUnLimitedQRCode(String path, String scene);



}
