package com.mmc.iuav.user.service;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.model.dto.UserAccountSimpleDTO;
import com.mmc.iuav.user.model.vo.UserAccountVO;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/16 13:48
 */
public interface UserAccountService {
    /**
     * Get the user account
     * @param unionId
     * @return
     */
    UserAccountVO getUserAccountInfoByUnionId(String unionId);

    /**
     * Insert the user account
     * @param userAccountDO
     */
    void insertUserAccount(UserAccountDO userAccountDO);

    /**
     * 通过用户id获取用户信息
     * @param userAccountId
     * @return
     */
    UserAccountVO getUserAccountById(Integer userAccountId);

    /**
     * 修改用户信息
     * @param userAccountVO
     * @return
     */
    ResultBody update(UserAccountVO userAccountVO);

    /**
     * 获取用户基本信息
     * @param userAccountId
     * @return
     */
    UserAccountSimpleDTO getUserSimpleInfo(Integer userAccountId);

    /**
     * 根据用户地区查询后台用户id
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    List<Integer> feignListUserAccountIds(Integer provinceCode, Integer cityCode, Integer districtCode);
}
