package com.mmc.iuav.user.controller;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.service.WxService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * @author: zj
 * @Date: 2023/5/17 11:16
 */
@Api(tags = "微信相关接口")
@RequestMapping("/wx/")
@RestController
public class WxController extends BaseController {

    @Autowired
    private WxService wxService;

    @ApiOperation(value = "小程序-获取当前用户的小程序推荐码")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = String.class) })
    @PostMapping("getAppletRcdCode")
    public ResultBody getAppletRcdCode(HttpServletRequest request, @ApiParam(value = "小程序路径",example = "pages/welcome/index") @RequestParam String page) {
        return wxService.getUnLimitedQRCode(page, "currentUserAccountId=" + this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "小程序-测试专用")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("testDemo")
    public ResultBody testDemo() {
        return ResultBody.success("app：" + "wxService.getAccessToken()" + "sub: " + wxService.getSubAccessToken());
    }

    /**
     * https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/url-link/urllink.generate.html#method-http
     * (有效期最长不超过30天)
     *
     * @param path
     * smsCode=SMS00003&scene=7  scene:表示用户用户来源渠道
     * @return
     */
    @ApiOperation(value = "URL_Link")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = Integer.class) })
    @GetMapping("createUrlLink")
    public ResultBody createUrlLink(
            @ApiParam(value = "小程序路径", required = false) @RequestParam(required = false) String path,
            @ApiParam(value = "路径携带参数", required = false) @RequestParam(required = false) String query) {
        return ResultBody.success(wxService.createUrlLink(path, query));
    }

    @ApiOperation(value = "监控微信公众号的事件变化通知", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = String.class) })
    @PostMapping("wxSendMessage")
    public void wxSendMessage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        req.setCharacterEncoding("UTF-8");
        resp.setCharacterEncoding("UTF-8");
        PrintWriter out = resp.getWriter();
        System.out.println("##########接收到微信事件推送############");
        String msg = wxService.receiveSubAccountEvents(req);
        out.println(msg);
    }

    @ApiOperation(value = "生成小程序码")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("getAppletQRCode")
    public ResultBody getAppletQRCode(@ApiParam(value = "小程序路径",example = "pages/welcome/index") @RequestParam String page,@ApiParam(value = "参数",example = "name=123&sex=456") @RequestParam String scene) {
        return wxService.getUnLimitedQRCode(page, scene);
    }
}
