package com.mmc.iuav.user.entity;

import com.alibaba.fastjson2.annotation.JSONField;
import com.mmc.iuav.user.model.vo.SystemMessageVO;
import com.mmc.iuav.user.model.vo.UserMessageVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author han
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class UserMessageDO implements Serializable {
    private static final long serialVersionUID = 973044768156590099L;
    /**
     * 消息ID
     */
    private Integer id;

    /**
     * 发送方
     */
    private Integer senderUserId;

    /**
     * 接收方
     */
    private Integer receiverUserId;

    /**
     * 消息内容
     */
    private String content;
    /**
     * 消息图片
     */
    private String imgUrl;

    /**
     * 创建时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;


    /**
     * 不为空则代表是跟商家在聊天
     */
    private Integer backUserId;

    public UserMessageDO(UserMessageVO message) {
        this.receiverUserId = message.getReceiverUserId();
        this.content = message.getContent();
        this.imgUrl = message.getImgUrl();
        this.backUserId = message.getBackUserId();
    }
}
