package com.mmc.iuav.user.service.xzsz.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.net.URLDecoder;
import cn.hutool.json.JSONObject;
import com.mmc.iuav.http.HttpsRequestUtil;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.constant.UserSystemConstant;
import com.mmc.iuav.user.dao.xzsz.XzDao;
import com.mmc.iuav.user.entity.XzAuthDO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.vo.XzAuthVO;
import com.mmc.iuav.user.model.vo.XzWithdrawalVO;
import com.mmc.iuav.user.service.xzsz.XzService;
import com.mmc.iuav.user.xzsz.SingleSubmitResp;
import com.mmc.iuav.user.xzsz.WithdrawalResp;
import com.piggy.settlement.sdk.client.sign.PiggySignApiClient;
import com.piggy.settlement.sdk.client.v2.bankreceipt.PiggyBankReceiptClient;
import com.piggy.settlement.sdk.client.v2.basics.PiggyOpenBasicsClient;
import com.piggy.settlement.sdk.client.v2.singlewithdraw.PiggySingleWithdrawalApiV2Client;
import com.piggy.settlement.sdk.util.v2.PiggyOpenBasicsAesUtil;
import com.piggy.settlement.sdk.vo.sign.PiggySignResultVo;
import com.piggy.settlement.sdk.vo.sign.PiggySignVo;
import com.piggy.settlement.sdk.vo.v2.bankreceipt.PiggyBankReceiptVo;
import com.piggy.settlement.sdk.vo.v2.basics.PiggyBasicsVo;
import com.piggy.settlement.sdk.vo.v2.singlewithdraw.PiggySingleWithdrawV2Vo;
import com.piggy.settlement.sdk.vo.v2.singlewithdraw.PiggySingleWithdrawalQueryV2Vo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

/**
 * @author: zj
 * @Date: 2023/8/21 9:52
 */
@Service
@Slf4j
public class XzServiceImpl implements XzService {
    @Autowired
    private UserSystemConstant userSystemConstant;

    @Autowired
    private XzDao xzDao;

    @Override
    public ResultBody getTaxFundList() {
        PiggyOpenBasicsClient piggyOpenBasicsClient = PiggyOpenBasicsClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggyOpenBasicsClient.getTaxFundList(PiggyBasicsVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .build());
        return ResultBody.success(jsonObject.get("data"));
    }

    @Override
    public ResultBody getCashPooling() {
        PiggyOpenBasicsClient piggyOpenBasicsClient = PiggyOpenBasicsClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggyOpenBasicsClient.getCashPooling(PiggyBasicsVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .build());
        System.out.println(jsonObject.toString());
        return ResultBody.success(jsonObject.get("data"));
    }

    @Override
    public ResultBody xzService() {
        PiggyOpenBasicsClient piggyOpenBasicsClient = PiggyOpenBasicsClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggyOpenBasicsClient.getTaxFundCashPooling(PiggyBasicsVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .taxFundID("8ae605f565884a1f9a5e91d5a661ce58")
                .build());
        System.out.println(jsonObject.toString());
        return ResultBody.success(jsonObject.get("data"));
    }

    @Override
    public String getContractScope(XzAuthVO xzAuthVO) {
        PiggySignApiClient piggySignApiClient = PiggySignApiClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggySignApiClient.getSignStatus(PiggySignResultVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .idCardNo(xzAuthVO.getIdCardNo())
                .userName(xzAuthVO.getUsername())
                .position(userSystemConstant.getXzPosition())
                .build());
        System.out.println(jsonObject.toString());
        return jsonObject.toString();
    }

    @Override
    public String hasKeyByUrl(XzAuthVO xzAuthVO, LoginSuccessDTO loginSuccessDTO) {
        // TODO 查询是否已认证
        String contractScope = this.getContractScope(xzAuthVO);
        com.alibaba.fastjson2.JSONObject jsonObject1 = com.alibaba.fastjson2.JSONObject.parseObject(contractScope);
        if (jsonObject1.get("data") != null) {
            // TODO 添加认证结果
            String signedResult = this.getSignedResult(xzAuthVO);
            
            return "合同签署完毕";
        } else {
            Map<String, Integer> userInfo = new HashMap<String, Integer>();
            userInfo.put("userAccountId", loginSuccessDTO.getUserAccountId());
            PiggySignApiClient piggySignApiClient = PiggySignApiClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
            JSONObject jsonObject = piggySignApiClient.getSignUrl(PiggySignVo.builder()
                    .appKey(userSystemConstant.getXzAppKey())
                    .customParams(com.alibaba.fastjson2.JSONObject.toJSONString(userInfo))
                    .idCardNo(xzAuthVO.getIdCardNo())
                    .infoSource("1")
                    .jumpPage("https://wwww.baidu.com")
                    .mobile(xzAuthVO.getMobile())
                    .notifyUrl(userSystemConstant.getAuthNotify())
                    .position(userSystemConstant.getXzPosition())
                    .userName(xzAuthVO.getUsername())
                    .build());
            // TODO 发送模板消息
            return jsonObject.get("data").toString();
        }
    }

    @Transactional
    @Override
    public String xzAuthNotify(JSONObject notify) {
        log.info("xzAuthNotify获取到的推送结果：{}", notify.toString());
        // 认证成功，修改认证状态
        if (notify.get("code").toString().equals("0")) {
            XzAuthDO authDO = notify.get("data", XzAuthDO.class);
            Map<String, Integer> map = new HashMap<String, Integer>();
            map.put("userAccountId", 1);
            authDO.setCustomParams(com.alibaba.fastjson2.JSONObject.toJSONString(map));
            Integer userAccountId = (Integer) com.alibaba.fastjson2.JSONObject.parseObject(authDO.getCustomParams()).get("userAccountId");
            if (userAccountId != null) {
                XzAuthDO xzAuthDO = xzDao.getXzAuthByUserAccountId(userAccountId);
                if (xzAuthDO == null) {
                    authDO.setUserAccountId(userAccountId);
                    authDO.setXzAuthStatus(1);
                    xzDao.addAuth(authDO);
                    return "success";
                }
            }
        }
        return null;
    }

    @Override
    public String getSignedResult(XzAuthVO xzAuthVO) {
        PiggySignApiClient piggySignApiClient = PiggySignApiClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggySignApiClient.getSignResult(PiggySignResultVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .idCardNo(xzAuthVO.getIdCardNo())
                .userName(xzAuthVO.getUsername())
                .build());
        System.out.println(jsonObject.toString());
        return jsonObject.toString();
    }

    @Override
    public String viewContract(String documentId) {
        PiggySignApiClient piggySignApiClient = PiggySignApiClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggySignApiClient.viewContract(documentId);
        System.out.println(jsonObject.toString());
        return jsonObject.toString();
    }

    @Override
    public ResultBody clearTestFace(String name, String idCard) {
        Map<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("idCard", idCard);
        String s = HttpsRequestUtil.httpsGet("https://uat.xzsz.ltd/contract/sign/clearTestPerson", map);
        return ResultBody.success(s);
    }

    @Override
    public SingleSubmitResp singleSubmit(XzWithdrawalVO xzWithdrawalVO) {
        xzWithdrawalVO.setNotifyUrl(userSystemConstant.getWithdrawNotify());
        PiggySingleWithdrawalApiV2Client v2Client = PiggySingleWithdrawalApiV2Client.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = v2Client.singleSubmit(PiggySingleWithdrawV2Vo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .bizAESContent(PiggyOpenBasicsAesUtil.produceAesData(userSystemConstant.getXzAppSecret(), "0000000000000000", PiggySingleWithdrawV2Vo.SingleWithdrawV2Vo.builder()
                        .notifyUrl(userSystemConstant.getWithdrawNotify())
                        .taxFundId(userSystemConstant.getTaxFundId())
                        .month(xzWithdrawalVO.getMonth())
                        .outerTradeNo(xzWithdrawalVO.getOuterTradeNo())
                        .empNum(xzWithdrawalVO.getEmpNum())
                        .empName(xzWithdrawalVO.getEmpName())
                        .empPhone(xzWithdrawalVO.getEmpPhone())
                        .licenseType(xzWithdrawalVO.getLicenseType())
                        .licenseId(xzWithdrawalVO.getLicenseId())
                        .settleType(xzWithdrawalVO.getSettleType())
                        .payAccount(xzWithdrawalVO.getPayAccount())
                        .positionName(xzWithdrawalVO.getPositionName())
                        .payAmount(xzWithdrawalVO.getPayAmount())
                        .bankRemo(xzWithdrawalVO.getBankRemo())
                        .build()))
                .build());
        log.info("singleSubmit res:{}", com.alibaba.fastjson2.JSONObject.toJSONString(jsonObject));
        SingleSubmitResp singleSubmitResp = com.alibaba.fastjson2.JSONObject.parseObject(jsonObject.toString(), SingleSubmitResp.class);
        return singleSubmitResp;
    }

    @Override
    public SingleSubmitResp singleSubmitLimit(XzWithdrawalVO xzWithdrawalVO) {
        PiggySingleWithdrawalApiV2Client v2Client = PiggySingleWithdrawalApiV2Client.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = v2Client.singleSubmitLimit(PiggySingleWithdrawV2Vo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .bizAESContent(PiggyOpenBasicsAesUtil.produceAesData(userSystemConstant.getXzAppKey(), "0000000000000000", PiggySingleWithdrawV2Vo.SingleWithdrawV2Vo.builder()
                        .notifyUrl(xzWithdrawalVO.getNotifyUrl())
                        .taxFundId(xzWithdrawalVO.getTaxFundId())
                        .month(xzWithdrawalVO.getMonth())
                        .outerTradeNo(xzWithdrawalVO.getOuterTradeNo())
                        .empNum(xzWithdrawalVO.getEmpNum())
                        .empName(xzWithdrawalVO.getEmpName())
                        .empPhone(xzWithdrawalVO.getEmpPhone())
                        .licenseType(xzWithdrawalVO.getLicenseType())
                        .licenseId(xzWithdrawalVO.getLicenseId())
                        .settleType(xzWithdrawalVO.getSettleType())
                        .payAccount(xzWithdrawalVO.getPayAccount())
                        .positionName(xzWithdrawalVO.getPositionName())
                        .payAmount(xzWithdrawalVO.getPayAmount())
                        .bankRemo(xzWithdrawalVO.getBankRemo())
                        .build()))
                .build());
        System.out.println(jsonObject.toString());
        SingleSubmitResp singleSubmitResp = com.alibaba.fastjson2.JSONObject.parseObject(jsonObject.toString(), SingleSubmitResp.class);
        return singleSubmitResp;
    }

    @Override
    public WithdrawalResp querySingleTrade(String outerTradeNo) {
        PiggySingleWithdrawalApiV2Client v2Client = PiggySingleWithdrawalApiV2Client.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = v2Client.querySingleTrade(PiggySingleWithdrawalQueryV2Vo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .outerTradeNo(outerTradeNo)
                .build());
        WithdrawalResp withdrawalResp = com.alibaba.fastjson2.JSONObject.parseObject(jsonObject.toString(), WithdrawalResp.class);
        return withdrawalResp;
    }

    @Override
    public ResultBody querySingleReceipt(String frontLogNo) {
        PiggyBankReceiptClient piggyBankReceiptClient = PiggyBankReceiptClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggyBankReceiptClient.getSingleReceipt(PiggyBankReceiptVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .frontLogNo(frontLogNo)
                .build());
        System.out.println(jsonObject.toString());
        if (jsonObject.get("isSuccess").toString().equals("T")) {
            return ResultBody.success(jsonObject.get("data"));
        } else {
            return ResultBody.error(jsonObject.get("errorMessage").toString());
        }
    }

    @Override
    public String xzWithdrawNotify(JSONObject notify) {
        log.info("xzWithdrawNotify获取到的推送结果：{}", notify.toString());
        // TODO 会受到两次回调
        if (notify.get("isSuccess").toString().equals("T")) {
            String s = decrypt(com.alibaba.fastjson2.JSONObject.parseObject(notify.get("data").toString()).get("bizAESContent").toString());
            WithdrawalResp.Data data = com.alibaba.fastjson2.JSONObject.parseObject(s, WithdrawalResp.Data.class);
            // TODO 判断是否已经处理，处理过就不用处理了
            if (data.getNotifyType().equals("submitResult")) {
                // 对上报的数据进行业务校验，例如：是否超限、是否有余额、是否有电签、参数是否准确等等前置校验。如果校验成功,订单进入待发队列等待发放
                log.info("deal submitResult");
                data.getOuterTradeNo();
            } else if (data.getNotifyType().equals("tradeResult")) {
                // 根据银行\微信\支付宝的反馈，推送订单的发放结果，发放成功\发放失败

                log.info("deal tradeResult");
            }
        } else {
            log.info("xzWithdrawNotify fail：{}", notify.toString());
        }
        return "success";
    }

    public String decrypt(String aesData) {
        try {
            byte[] raw = userSystemConstant.getXzAppSecret().getBytes("ASCII");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec iv = new IvParameterSpec("0000000000000000".getBytes());
            cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);
            Charset charset = Charset.forName("UTF-8");
            String tempStr = URLDecoder.decode(aesData, charset);
            byte[] encrypted1 = Base64.decode(tempStr);
            byte[] original = cipher.doFinal(encrypted1);
            String jsonParam = new String(original, "UTF-8");
            return jsonParam;
        } catch (Exception e) {
            System.out.println("AES解密异常" + e);
        }
        return "";
    }

}
