package com.mmc.iuav.user.entity.wallet;

import com.mmc.iuav.user.model.vo.wallet.UserBillingDetailVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 现金流水表(PayLogDO)实体类
 *
 * @author makejava
 * @since 2023-08-18 16:18:01
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PayLogDO implements Serializable {
    private static final long serialVersionUID = 752682324297846133L;

    private Integer id;
    /**
     * 支付人的userId
     */
    private Integer userAccountId;
    /**
     * 订单编号
     */
    private Integer orderNo;
    /**
     * 支付流水号(T202109031615XXXX)XXXX随机数
     */
    private String payNo;
    /**
     * 支付方式 100（订单发布） 200(无人接单取消订单）300（有人接单取消订单）400（飞手抢单）500（客服判定飞手无责取消订单）
     * 600（飞手有责取消订单）700（正常结算）800(修改订单金额状态)900（飞手未确认修改金额状态）1000（飞手确认修改金额状态）1100（充值） 1200（提现）
     */
    private Integer payMethod;
    /**
     * 云享金变动金额(正数充值，负数扣除)
     */
    private BigDecimal cashAmtPaid;
    /**
     * 佣金变动金额(正数入账，负数扣除)
     */
    private BigDecimal salaryAmtPaid;
    /**
     * 支付时间
     */
    private Date payTime;
    /**
     * 备注
     */
    private String remark;
    /**
     * 操作用户id
     */
    private Integer operateUser;

    private Date createTime;

    private Date updateTime;

    private String name;

    public UserBillingDetailVO buildUserBillingDetailVO() {
        return UserBillingDetailVO.builder().userAccountId(userAccountId).payNo(payNo)
                .payTime(payTime).payMethod(payMethod).cashAmtPaid(cashAmtPaid)
                .salaryAmtPaid(salaryAmtPaid).name(name).id(id).build();
    }
}

