package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.enums.SettleTypeEnum;
import com.mmc.iuav.user.model.vo.XzWithdrawalVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/8/23 16:17
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class XzWithdrawalApplyDO implements Serializable {
    private static final long serialVersionUID = 7891653696372539753L;
    private Integer id;
    private Integer userAccountId;
    private String bankName;
    private String bankRemo;
    private String empNum;
    private String empName;
    private String empPhone;
    private String licenseId;
    private String licenseType;
    private String month;
    private String notifyUrl;
    private String outerTradeNo;
    private String payAccount;
    private Double payAmount;
    private String positionName;
    private String remarks;
    private String settleType;
    private String taxFundId;
    private String wechatAppId;
    private String tradeStatus;
    private String tradeTime;
    private String frontLogNo;
    private String tradeFailCode;
    private String tradeResult;
    private String submitStatus;
    private String errorCode;
    private String errorMessage;
    private BigDecimal chargeAmount;
    private Date createTime;

    public XzWithdrawalApplyDO(XzWithdrawalVO xzWithdrawalVO) {
        this.userAccountId = xzWithdrawalVO.getUserAccountId();
        this.notifyUrl = xzWithdrawalVO.getNotifyUrl();
        this.taxFundId = xzWithdrawalVO.getTaxFundId();
        this.month = xzWithdrawalVO.getMonth();
        this.outerTradeNo = xzWithdrawalVO.getOuterTradeNo();
        this.empName = xzWithdrawalVO.getEmpName();
        this.empPhone = xzWithdrawalVO.getEmpPhone();
        this.empNum = xzWithdrawalVO.getEmpNum();
        this.licenseId = xzWithdrawalVO.getLicenseId();
        this.licenseType = xzWithdrawalVO.getLicenseType();
        this.settleType = xzWithdrawalVO.getSettleType();
        this.payAmount = xzWithdrawalVO.getPayAmount();
        this.payAccount = xzWithdrawalVO.getSettleType().equals(SettleTypeEnum.BANK.getCode()) ?
                xzWithdrawalVO.getPayAccount() : xzWithdrawalVO.getWechatAppId();
        this.bankName = xzWithdrawalVO.getBankName();
        this.positionName = xzWithdrawalVO.getPositionName();
        this.remarks = xzWithdrawalVO.getRemarks();
        this.bankRemo = xzWithdrawalVO.getBankRemo();
    }

}
