package com.mmc.iuav.user.controller.xzsz;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.vo.XzWithdrawalVO;
import com.mmc.iuav.user.service.xzsz.WithdrawalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author: zj
 * @Date: 2023/8/23 15:58
 */
@Slf4j
@Api(tags = "提现相关")
@RequestMapping("/withdrawal/")
@RestController
public class WithdrawalController extends BaseController {

    @Autowired
    private WithdrawalService withdrawalService;

    @ApiOperation(value = "提现申请")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("apply")
    public ResultBody apply(@RequestBody XzWithdrawalVO xzWithdrawalVO) {
        return withdrawalService.apply(xzWithdrawalVO);
    }

    // 提现查询

    // 个人提现列表

    // 全部用户提现列表

}
