package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.dto.MenuInfoDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/7/11 14:49
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MenuInfoDO implements Serializable {
    private static final long serialVersionUID = -4992870152816350664L;
    private Integer id;
    /**
     * 父级id
     */
    private Integer pid;
    /**
     * 菜单名
     */
    private String menuName;
    /**
     * 菜单类型：0菜单，1按钮
     */
    private String domType;
    /**
     * 菜单路径
     */
    private String pathInfo;
    /**
     * 菜单图标
     */
    private String icon;
    /**
     * 序号
     */
    private Integer sort;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    public MenuInfoDTO buildMenuInfoDTO() {
        return MenuInfoDTO.builder().id(this.id).pid(this.pid).menuName(this.menuName).domType(this.domType)
                .pathInfo(this.pathInfo).icon(this.icon).build();
    }
}
