package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Page;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.UserAccountSimpleDTO;
import com.mmc.iuav.user.model.qo.UserAccountQO;
import com.mmc.iuav.user.model.qo.UserMessageQO;
import com.mmc.iuav.user.model.qo.UserRcdQO;
import com.mmc.iuav.user.model.vo.UserAccountVO;
import com.mmc.iuav.user.service.UserAccountService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/15 15:32
 */
@Api(tags = "小程序用户账号相关接口")
@RequestMapping("/user-account/")
@RestController
public class UserAccountController extends BaseController {

    @Autowired
    private UserAccountService userAccountService;

    @ApiOperation(value = "客户列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserAccountVO.class)})
    @PostMapping("listAppUser")
    public ResultBody<UserAccountVO> listAppUser(@Validated(value = {Page.class}) @RequestBody UserAccountQO userAccountQO, HttpServletRequest request) {
        return userAccountService.listAppUser(userAccountQO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "获取用户信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserAccountVO.class)})
    @GetMapping("info")
    public ResultBody<UserAccountVO> info(HttpServletRequest request) {
        return ResultBody.success(userAccountService.getUserAccountById(this.getUserLoginInfoFromRedis(request).getUserAccountId()));
    }

    @ApiOperation(value = "修改用户信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("update")
    public ResultBody update(@Validated(value = {Update.class}) @RequestBody UserAccountVO userAccountVO) {
        return userAccountService.update(userAccountVO);
    }


    @ApiOperation(value = "获取用户基本信息", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserAccountSimpleDTO.class)})
    @GetMapping("feignGetUserSimpleInfo")
    public UserAccountSimpleDTO feignGetUserSimpleInfo(@RequestParam Integer userAccountId) {
        return userAccountService.getUserSimpleInfo(userAccountId);
    }

    @ApiOperation(value = "根据用户地区查询后台用户id", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserAccountSimpleDTO.class)})
    @GetMapping("feignListUserAccountIds")
    public List<Integer> feignListUserAccountIds(@RequestParam Integer provinceCode, @RequestParam(required = false) Integer cityCode, @RequestParam(required = false) Integer districtCode) {
        return userAccountService.feignListUserAccountIds(provinceCode, cityCode, districtCode);
    }

    @ApiOperation(value = "授权手机号-裂变邀请")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = Integer.class)})
    @GetMapping("getUserPhoneNumber")
    public ResultBody getUserPhoneNumber(HttpServletRequest request,
                                         @ApiParam(value = "授权手机号code", required = true) @RequestParam String code,
                                         @ApiParam(value = "邀请人id", required = false) @RequestParam(required = false) Integer rcdUserId) {
        return userAccountService.getUserPhoneNumber(this.getUserLoginInfoFromRedis(request).getUserAccountId(), code, rcdUserId);
    }

    @ApiOperation(value = "根据用户id查询用户信息", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserAccountSimpleDTO.class)})
    @PostMapping("feignListUserAccountByIds")
    public List<UserAccountSimpleDTO> feignListUserAccountByIds(@RequestBody List<Integer> ids) {
        return userAccountService.feignListUserAccountByIds(ids);
    }

    @ApiOperation(value = "根据条件查询用户信息", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserAccountSimpleDTO.class)})
    @PostMapping("feignListAppUserAccount")
    public List<UserAccountSimpleDTO> feignListAppUserAccount(@ApiParam(value = "账号查询QO", required = true) @RequestBody UserAccountQO userAccountQO) {
        return userAccountService.feignListUserAccount(userAccountQO);
    }

    @ApiOperation(value = "根据用户ids上级推荐人信息", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserAccountSimpleDTO.class)})
    @PostMapping("feignListRcdUserInfo")
    public List<UserAccountSimpleDTO> feignListRcdUserInfo(@RequestBody List<Integer> userIds) {
        return userAccountService.feignListRcdUserInfo(userIds);
    }

    @ApiOperation(value = "查询上级推荐人id", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = Integer.class)})
    @GetMapping("feignGetSuperiorRef")
    public Integer feignGetSuperiorRef(@RequestParam Integer userAccountId) {
        return userAccountService.feignGetSuperiorRef(userAccountId);
    }

    @ApiOperation(value = "查询上级推荐人信息", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserAccountSimpleDTO.class)})
    @GetMapping("feignGetUserRcdInfo")
    public UserAccountSimpleDTO feignGetUserRcdInfo(@RequestParam Integer userAccountId) {
        return userAccountService.feignGetUserRcdInfo(userAccountId);
    }

    @ApiOperation(value = "账号-禁用（原删除）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("removeAppAccount")
    public ResultBody disableAppAccount(@RequestParam Integer userAccountId, HttpServletRequest request) {
        return userAccountService.disableAppAccount(userAccountId);
    }

    @ApiOperation(value = "裂变-邀请人数")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("countRcd")
    public ResultBody countRcd(@RequestParam Integer userAccountId) {
        return userAccountService.countRcd(userAccountId);
    }

    @ApiOperation(value = "裂变-邀请列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("listUserRcd")
    public ResultBody listUserRcd(@RequestBody UserRcdQO userRcdQO) {
        return userAccountService.listUserRcd(userRcdQO);
    }

    @ApiOperation(value = "裂变-邀请排行榜")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("topRcd")
    public ResultBody topRcd(@RequestParam(required = false, defaultValue = "10") Integer topNum) {
        return userAccountService.topRcd(topNum);
    }

    @ApiOperation(value = "手机号查询用户信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("getUserAccountByPhoneNum")
    public ResultBody getUserAccountByPhoneNum(@RequestParam String phoneNum) {
        return userAccountService.getUserAccountByPhoneNum(phoneNum);
    }

    @ApiOperation(value = "获取修改手机获取验证码")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("getVerifyCode")
    public ResultBody getVerifyCode(@RequestParam(value = "userAccountId") Integer userAccountId,
                                    @RequestParam(value = "phoneNum") String phoneNum) {
        return userAccountService.getVerifyCode(userAccountId, phoneNum);
    }

    @ApiOperation(value = "修改用户手机号")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("updatePhoneNum")
    public ResultBody updatePhoneNum(@RequestParam(value = "userAccountId") Integer userAccountId,
                                     @RequestParam(value = "verifyCode") String verifyCode) {
        return userAccountService.updatePhoneNum(userAccountId, verifyCode);
    }

    @ApiOperation(value = "new_修改用户信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/appUpdateUser")
    public ResultBody appUpdateUser(@RequestBody UserMessageQO userMessageQO){
        return userAccountService.appUpdateUser(userMessageQO);
    }


    @ApiOperation(value = "内部使用获取用户信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserAccountVO.class)})
    @GetMapping("interiorInfo")
    public ResultBody<UserAccountVO> interiorInfo(HttpServletRequest request,Integer userAccountId) {
        return ResultBody.success(userAccountService.getUserAccountById(userAccountId));
    }





}
