package com.mmc.iuav.user.model.vo.wallet;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author: lw
 * @Date: 2023/8/25 10:25
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ApplyWithdrawalVO implements Serializable {
    private static final long serialVersionUID = 8677383830415176214L;
    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;
    @ApiModelProperty(value = "户名")
    private String empName;
    @ApiModelProperty(value = "手机号")
    private String empPhone;
    @ApiModelProperty(value = "交易类型（bankcard：银行卡，alipay：支付宝，wechatpay：微信）", required = true)
    private String settleType;
    @ApiModelProperty(value = "收款账号，交易类型为支付宝时，为支付宝账号；交易类型为微信时，填收款用户的openid", required = true)
    private String payAccount;
    @ApiModelProperty(value = "收款人银行名称 （无需细到支行名称）")
    private String bankName;
    @ApiModelProperty(value = "服务类型，测试：销售推广；正式：市场推广", required = true)
    private String positionName;
    @ApiModelProperty(value = "交易金额（实际到账金额， 单位元，精确两位小数 ）", required = true)
    private BigDecimal payAmount;
}
