package com.mmc.iuav.user.model.qo.wallet;

import com.mmc.iuav.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author 作者 lw
 * @version 创建时间：2023.8.26 上午11:40:21
 * @explain 类说明
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WalletFlowQO implements Serializable {
    private static final long serialVersionUID = -2568266056802132237L;
    @ApiModelProperty(value = "用户id", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "查询年-月")
    private String yearMonth;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间", hidden = true)
    private String endTime;

    @ApiModelProperty(value = "状态类型")
    private Integer payMethod;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = {Page.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = {Page.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
