package com.mmc.iuav.user.model.dto.dronepilot;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * @Author small
 * @Date 2023/7/28 10:59
 * @Version 1.0
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class PilotAbilityDTO {
    @ApiModelProperty(value = "能力id不能为空", example = "航拍摄影,农业植保", required = true)
    @NotBlank(message = "能力id不能为空", groups = {Create.class, Update.class})
    private Integer abilityId;

    @ApiModelProperty(value = "能力不能为空", example = "航拍摄影,农业植保", required = true)
    @NotBlank(message = "能力名称不能为空", groups = {Create.class, Update.class})
    private String abilityName;
    

}
