package com.mmc.iuav.user.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/7/27 14:49
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "实名认证DTO")
public class RealNameAuthDTO implements Serializable {
    private static final long serialVersionUID = -1449716605649423527L;
    @ApiModelProperty(value = "实名认证id")
    private Integer id;
    @ApiModelProperty(value = "用户userAccountId")
    private Integer userAccountId;
    @ApiModelProperty(value = "实名认证状态")
    private Integer checkStatus;
    @ApiModelProperty(value = "真实姓名")
    private String userName;
    @ApiModelProperty(value = "身份证号码")
    private String idNumber;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "用户uid")
    private String uid;
    @ApiModelProperty(value = "用户昵称")
    private String nickName;
    @ApiModelProperty(value = "用户常驻地址")
    private String resAddress;
    @ApiModelProperty(value = "手机号")
    private String phoneNum;
    @ApiModelProperty(value = "实名认证时间")
    private String createTime;

}
