package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.group.UpdatePassword;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.BaseAccountDTO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.dto.UserAccountSimpleDTO;
import com.mmc.iuav.user.model.qo.BUserAccountQO;
import com.mmc.iuav.user.model.vo.BUserAccountVO;
import com.mmc.iuav.user.model.vo.UserAccountVO;
import com.mmc.iuav.user.service.UserAccountService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.security.NoSuchAlgorithmException;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/25 11:22
 */
@Api(tags = "后台用户相关接口")
@RequestMapping("/back-user/")
@RestController
public class BackUserAccountController extends BaseController{

    @Autowired
    private UserAccountService userAccountService;

    @ApiOperation(value = "账号-新增")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insertBAccount")
    public ResultBody insertBAccount(@Validated(value = {Create.class}) @RequestBody BUserAccountVO bUserAccountVO) {
        return userAccountService.insertBAccount(bUserAccountVO);
    }

    @ApiOperation(value = "账号-修改")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updateBAccount")
    public ResultBody updateBAccount(@Validated(value = {Update.class}) @RequestBody BUserAccountVO bUserAccountVO) {
        return userAccountService.updateBAccount(bUserAccountVO);
    }

    @ApiOperation(value = "账号-删除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("removeBAccount")
    public ResultBody removeBAccount(@RequestParam Integer userAccountId, HttpServletRequest request) {
        return userAccountService.removeBAccount(userAccountId);
    }

    @ApiOperation(value = "账号-列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("listBAccountPage")
    public ResultBody<UserAccountSimpleDTO> listBAccountPage(@ApiParam(value = "账号查询QO", required = true)  @RequestBody BUserAccountQO bUserAccountQO) {
        return userAccountService.listBAccountPage(bUserAccountQO);
    }

    @ApiOperation(value = "账号-用户列表-内部调用", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = List.class)})
    @PostMapping("feignListBAccountPage")
    public List<UserAccountSimpleDTO> feignListBAccountPage(@ApiParam(value = "账号查询QO", required = true)  @RequestBody BUserAccountQO bUserAccountQO) {
        return userAccountService.feignListBAccountPage(bUserAccountQO);
    }

    @ApiOperation(value = "账号管理-修改密码")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updatePassword")
    public ResultBody updatePassword(@Validated(value = {UpdatePassword.class}) @RequestBody BUserAccountVO account)
            throws NoSuchAlgorithmException {
        return userAccountService.updatePassword(account);
    }

    @ApiOperation(value = "feign-验证用户密码")
    @ApiIgnore
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("feignAuthUserPwd")
    public ResultBody feignAuthUserPwd(@RequestParam(required = true) Integer id,
                                       @RequestParam(required = true) String authPwd) {
        return userAccountService.feignAuthUserPwd(id, authPwd);
    }

    @ApiOperation(value = "test")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("listTest")
    public ResultBody listTest(HttpServletRequest request) {
        return ResultBody.success();
    }
}
