package com.mmc.iuav.user.entity.activity;

import com.mmc.iuav.user.model.dto.activity.ActivityDTO;
import com.mmc.iuav.user.model.vo.activity.ActivityVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/10/16 14:42
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ActivityDO implements Serializable {
    private static final long serialVersionUID = -1748125765671153744L;
    private Integer id;
    private Integer activityType;
    private String activityName;
    private Date startTime;
    private Date endTime;
    private String description;
    private Integer activityStatus;
    private Integer rewardType;
    private Integer rewardValue;
    private Integer requireNum;
    private Date createTime;
    private List<ActivityPartDO> activityPartDTOS;

    public ActivityDTO buildActivityDTO() {
        return ActivityDTO.builder().id(this.id).activityType(this.activityType).activityName(this.activityName).activityStatus(this.activityStatus)
                .startTime(this.startTime).endTime(this.endTime).description(this.description).rewardType(this.rewardType).rewardValue(this.rewardValue)
                .requireNum(this.requireNum).createTime(this.createTime).activityPartDTOS(CollectionUtils.isEmpty(this.activityPartDTOS) ? null :
                        this.activityPartDTOS.stream().map(ActivityPartDO::buildActivityPartDTO).collect(Collectors.toList())
                ).build();
    }

    public ActivityDO(ActivityVO activityVO) {
        this.id = activityVO.getId();
        this.activityType = activityVO.getActivityType();
        this.activityName = activityVO.getActivityName();
        this.activityStatus = activityVO.getActivityStatus();
        this.startTime = activityVO.getStartTime();
        this.endTime = activityVO.getEndTime();
        this.description = activityVO.getDescription();
        this.rewardType = activityVO.getRewardType();
        this.rewardValue = activityVO.getRewardValue();
        this.requireNum = activityVO.getRequireNum();
    }
}
