package com.mmc.iuav.user.model.vo.activity;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/10/16 14:50
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ActivityVO implements Serializable {
    private static final long serialVersionUID = -7232980603049531614L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;
    @ApiModelProperty(value = "活动类型")
    @NotNull(message = "活动类型不能为空", groups = {Insert.class, Update.class})
    private Integer activityType;
    @ApiModelProperty(value = "活动名称")
    @NotBlank(message = "活动名称不能为空", groups = {Insert.class, Update.class})
    private String activityName;
    @ApiModelProperty(value = "开始时间")
    @NotNull(message = "活动开始时间不能为空", groups = {Insert.class, Update.class})
    private Date startTime;
    @ApiModelProperty(value = "结束时间")
    @NotNull(message = "活动结束时间不能为空", groups = {Insert.class, Update.class})
    private Date endTime;
    @ApiModelProperty(value = "描述")
    private String description;
    @ApiModelProperty(value = "活动状态：0暂停， 1进行中")
    @NotNull(message = "活动状态不能为空", groups = {Insert.class, Update.class})
    private Integer activityStatus;
    @ApiModelProperty(value = "奖励类型（0积分，1余额，2优惠券）")
    @NotNull(message = "奖励类型不能为空", groups = {Insert.class, Update.class})
    private Integer rewardType;
    @ApiModelProperty(value = "奖励额度")
    @NotNull(message = "奖励额度不能为空", groups = {Insert.class, Update.class})
    private Integer rewardValue;
    @ApiModelProperty(value = "人数限制")
    @NotNull(message = "人数限制不能为空", groups = {Insert.class, Update.class})
    private Integer requireNum;
}
