package com.mmc.iuav.user.model.vo;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Update;
import io.swagger.annotations.ApiModelProperty;
import jdk.nashorn.internal.runtime.Debug;
import lombok.*;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;

/**
 * @Author small
 * @Date 2023/7/13 16:07
 * @Version 1.0
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LicenseOrganizationsVO {
    private static final long serialVersionUID = -5814724843819090363L;
    @ApiModelProperty(value = "机构id", example = "1")
    @NotNull(message = "机构id", groups = Update.class)
    private Integer id;

    @ApiModelProperty(value = "机构主图不能为空", example = "http://", required = true)
    @NotBlank(message = "机构主图不能为空", groups = {Create.class, Update.class})
    private String mainImage;

    @ApiModelProperty(value = "机构副图不能为空", example = "http://", required = true)
    //@NotBlank(message = "机构副图不能为空", groups = {Create.class, Update.class})
    private String auxiliaryPicture;

    @ApiModelProperty(value = "机构视频", example = "http://")
    private String video;

    @ApiModelProperty(value = "机构名称不能为空", example = "科比特智能教育", required = true)
    @NotBlank(message = "机构名称不能为空", groups = {Create.class, Update.class})
    @Size(max = 25, message = "机构名称不能超过25个字符")
    private String name;

    @ApiModelProperty(value = "机构地区编号", example = "110000,130100", required = true)
    @NotBlank(message = "机构地区不能为空", groups = {Create.class, Update.class})
    private String region;

    @ApiModelProperty(value = "机构地区名称", example = "河北省,石家庄市", required = false)
    //@NotBlank(message = "机构地区名称", groups = {Create.class, Update.class})
    private String regionName;

    @ApiModelProperty(value = "经度", example = "40.892313123", required = true)
    private Double longitude;

    @ApiModelProperty(value = "纬度", example = "50.892313123", required = true)
    private Double latitude;

    @ApiModelProperty(value = "机构详细地址", example = "南山区", required = false)
    //@NotBlank(message = "机构详细地址不能为空", groups = {Create.class, Update.class})
    private String detailedAddress;


    @ApiModelProperty(value = "是否是考点机构 0否 1是", example = "0", required = true)
    @NotNull(message = "考点机构不能为空 0否 1是", groups = {Create.class, Update.class})
    private Integer testCenter;

    @ApiModelProperty(value = "机构规模id不能为空", example = "1")
    //@NotNull(message = "机构规模id不能为空", groups = {Create.class, Update.class})
    // @Size(max = 4, message = "机构规模id不能超过4", groups = {Create.class, Update.class})
    @Max(value = 4,  groups = {Create.class, Update.class},message = "机构规模id不能超过4")
    private Integer scaleId;

    @ApiModelProperty(value = "机构描述", example = "机构描述0001")
    //@NotNull(message = "机构描述", groups = {Create.class, Update.class})
    private String description;

    @ApiModelProperty(value = "机构详情", example = "机构详情0001", required = true)
    @NotNull(message = "机构详情", groups = {Create.class, Update.class})
    private String detail;

    @ApiModelProperty(value = "后台用户id")
    private Integer backUserId;

}
