package com.mmc.iuav.user.model.qo.dronepilot;

import com.mmc.iuav.group.Freeze;
import com.mmc.iuav.group.Page;
import com.mmc.iuav.user.model.dto.dronepilot.LicenseType;
import com.mmc.iuav.user.model.vo.dronepilot.EnumValue;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/7/29 10:14
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PilotCertificationQO implements Serializable {

    private static final long serialVersionUID = -3729786590325257669L;
    @ApiModelProperty(value = "飞手认证id")
    private Integer id;

    @ApiModelProperty(value = "地区编码", required = false)
    private Integer areaNumber;

    @ApiModelProperty(value = "能力认证id", required = false, example = "1")
    private Integer abilityId;

    @ApiModelProperty(value = "执照类型 CAAC,UTC,OTHER(其他) 目前只有三种", example = "UTC", required = false)
    @EnumValue(enumClass = LicenseType.class, message = "取值不合法,参考:LicenseType")
    private String licenseType;

    @ApiModelProperty(value = "账号筛选（uid,姓名，手机号）", required = false, example = "张三")
    private String accountNumber;

    @ApiModelProperty(value = "审核是否通过 0审核中 1审核通过 2审核不通过", required = false, example = "0")
    private Integer auditStatus;


    @ApiModelProperty(value = "当前页", required = true, example = "1")
    @NotNull(message = "当前页不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "页大小", required = true, example = "10")
    @NotNull(message = "页大小不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }

    @ApiModelProperty(value = "",hidden = true)
    private Integer tokenUserId;

    @ApiModelProperty(value = "飞手团队的后台id")
    private Integer backUserId;

    @ApiModelProperty(value = "查询的飞手是否要有团队 1有团队 0 没有")
    private int isTeam;

}
