package com.mmc.iuav.user.service;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.BackUserAccountDO;
import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.entity.UserStateDO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.dto.UserAccountSimpleDTO;
import com.mmc.iuav.user.model.dto.UserBaseInfoDTO;
import com.mmc.iuav.user.model.qo.UserAccountQO;
import com.mmc.iuav.user.model.qo.UserMessageQO;
import com.mmc.iuav.user.model.qo.UserRcdQO;
import com.mmc.iuav.user.model.vo.UserAccountMessageVo;
import com.mmc.iuav.user.model.vo.UserAccountVO;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/16 13:48
 */
public interface UserAccountService {
    /**
     * Get the user account
     *
     * @param unionId
     * @return
     */
    UserAccountVO getUserAccountInfoByUnionId(String unionId);
    UserAccountVO getUserAccountInfoByPhoneNum(String phoneNum);

    /**
     * Insert the user account
     *
     * @param userAccountDO
     */
    void insertUserAccount(UserAccountDO userAccountDO);

    /**
     * 通过用户id获取用户信息
     *
     * @param userAccountId
     * @return
     */
    UserAccountVO getUserAccountById(Integer userAccountId);

    /**
     * 修改用户信息
     *
     * @param userAccountVO
     * @return
     */
    ResultBody update(UserAccountVO userAccountVO);

    /**
     * 获取用户基本信息
     *
     * @param userAccountId
     * @return
     */
    UserAccountSimpleDTO getUserSimpleInfo(Integer userAccountId);

    /**
     * 根据用户地区查询后台用户id
     *
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    List<Integer> feignListUserAccountIds(Integer provinceCode, Integer cityCode, Integer districtCode);

    /**
     * 内部获取用户列表
     *
     * @param userAccountQO
     * @return
     */
    List<UserAccountSimpleDTO> feignListUserAccount(UserAccountQO userAccountQO);

    /**
     * 授权手机号
     *
     * @param id
     * @param code
     * @param rcdUserId
     * @return
     */
    ResultBody getUserPhoneNumber(Integer id, String code, Integer rcdUserId);

    /**
     * 根据id获取用户信息
     *
     * @param ids
     * @return
     */
    List<UserAccountSimpleDTO> feignListUserAccountByIds(List<Integer> ids);

    /**
     * 根据id获取用户信息,包括已删除的
     *
     * @param ids
     * @return
     */
    List<UserAccountSimpleDTO> feignListAllUserAccountByIds(List<Integer> ids);

    /**
     * 根据用户id获取推荐人信息
     *
     * @param userIds
     * @return
     */
    List<UserAccountSimpleDTO> feignListRcdUserInfo(List<Integer> userIds);

    /**
     * 获取推荐人id
     *
     * @param userAccountId
     * @return
     */
    Integer feignGetSuperiorRef(Integer userAccountId);

    /**
     * 获取推荐人信息
     *
     * @param userAccountId
     * @return
     */
    UserAccountSimpleDTO feignGetUserRcdInfo(Integer userAccountId);

    /**
     * 用户列表
     *
     * @param userAccountQO
     * @return
     */
    ResultBody listAppUser(UserAccountQO userAccountQO, LoginSuccessDTO loginSuccessDTO);

    /**
     * 删除小程序用户
     *
     * @param userAccountId
     * @return
     */
    ResultBody disableAppAccount(Integer userAccountId);

    /**
     * 用户邀请人数
     *
     * @param userAccountId
     * @return
     */
    ResultBody countRcd(Integer userAccountId);

    /**
     * 用户邀请列表
     *
     * @param userRcdQO
     * @return
     */
    ResultBody listUserRcd(UserRcdQO userRcdQO);

    /**
     * 邀请排行榜
     *
     * @param topNum
     * @return
     */
    ResultBody topRcd(Integer topNum);

    /**
     * 通过手机号查询用户信息
     *
     * @param phoneNum
     * @return
     */
    ResultBody getUserAccountByPhoneNum(String phoneNum);

    ResultBody getVerifyCode(Integer userAccountId, String phoneNum);

    ResultBody updatePhoneNum(Integer userAccountId, String verifyCode);

    ResultBody appUpdateUser(UserMessageQO userMessageQO);

    UserAccountMessageVo userMessages(Integer userAccountId);

    UserBaseInfoDTO feignGetUserBaseInfo(Integer userAccountId);

    /**
     * 根据手机号查询unionId
     */
    String selectUnionIdByPhone(String phone);

    ResultBody getStateList();

}
