package com.mmc.iuav.user.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/8/21 20:14
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class XzWithdrawalVO implements Serializable {
    private static final long serialVersionUID = -8758847907824399671L;
    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;
    @ApiModelProperty(value = "回调地址")
    private String notifyUrl;
    @ApiModelProperty(value = "税源地id")
    private String taxFundId;
    @ApiModelProperty(value = "提现月份")
    private String month;
    @ApiModelProperty(value = "商户业务流水号（商户自行生成，全局唯一）")
    private String outerTradeNo;
    @ApiModelProperty(value = "自定义员工编号（商户系统中用户唯一编号）")
    private String empNum;
    @ApiModelProperty(value = "收款人户名")
    private String empName;
    @ApiModelProperty(value = "收款人手机号")
    private String empPhone;
    @ApiModelProperty(value = "收款人证件类型：ID_CARD")
    private String licenseType;
    @ApiModelProperty(value = "收款人证件号码")
    private String licenseId;
    @ApiModelProperty(value = "交易类型（bankcard：银行卡，alipay：支付宝，wechatpay：微信）")
    private String settleType;
    @ApiModelProperty(value = "收款账号，交易类型为支付宝时，为支付宝账号；交易类型为微信时，填收款用户的openid")
    private String payAccount;
    @ApiModelProperty(value = "收款人银行名称 （无需细到支行名称）")
    private String bankName;
    @ApiModelProperty(value = "服务类型，测试：销售推广；正式：市场推广")
    private String positionName;
    @ApiModelProperty(value = "交易金额（实际到账金额， 单位元，精确两位小数 ）")
    private Double payAmount;
    @ApiModelProperty(value = "业务备注说明：若需要对每笔提现区分业务来源，可自行定义，后续可在SaaS后台查看，与用户到账说明无关（不能超过10个字）")
    private String remarks;
    @ApiModelProperty(value = "银行摘要备注（可在收款行交易明细中查看到")
    private String bankRemo;
    @ApiModelProperty(value = "商户自己的微信APPID，交易类型为微信时，必填")
    private String wechatAppId;
}
