package com.mmc.iuav.user.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/7/27 14:49
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "实名认证详情DTO")
public class RealNameAuthDetailDTO implements Serializable {
    private static final long serialVersionUID = 3101785098483923008L;
    @ApiModelProperty(value = "实名认证id")
    private Integer id;
    @ApiModelProperty(value = "用户userAccountId")
    private Integer userAccountId;
    @ApiModelProperty(value = "身份证正面")
    private String frontIdImg;
    @ApiModelProperty(value = "身份证背面")
    private String backIdImg;
    @ApiModelProperty(value = "身份证号")
    private String idNumber;
    @ApiModelProperty(value = "姓名")
    private String userName;
    @ApiModelProperty(value = "状态")
    private Integer checkStatus;
}
