/*
 * Decompiled with CFR 0.152.
 */
package com.fadada.sdk.http.handler;

import com.alibaba.fastjson.JSON;
import com.fadada.sdk.api.API;
import com.fadada.sdk.enums.ErrorMessage;
import com.fadada.sdk.exception.SDKException;
import com.fadada.sdk.http.HttpClient;
import com.fadada.sdk.http.RequestParameter;
import com.fadada.sdk.model.ReturnBaseT;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class Executor {
    private HttpClient httpClient;

    public String execute(HttpClient httpClient, API api) throws SDKException {
        this.httpClient = httpClient;
        RequestParameter requestParameter = this.beforeExecute(api);
        Response response = this.executionMethod(api.getHttpMethod(), requestParameter, api);
        if (!api.hasDownload()) {
            return this.afterExecute(response);
        }
        return this.afterExecute(response, requestParameter);
    }

    private String afterExecute(Response response, RequestParameter requestParameter) {
        Source source = null;
        Sink sink = null;
        try {
            ResponseBody body = response.body();
            if (body == null) {
                String string = null;
                return string;
            }
            if ("application/json;charset=utf-8".equals(Objects.requireNonNull(body.contentType()).toString())) {
                String string = body.string();
                return string;
            }
            String path = (String)requestParameter.getData().get("path");
            source = body.source();
            File file = new File(path);
            sink = Okio.buffer(Okio.sink(file));
            sink.writeAll(source);
            sink.flush();
            String string = JSON.toJSONString(new ReturnBaseT<Object>(1, "success", null));
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (source != null) {
                    source.close();
                }
                if (sink != null) {
                    sink.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String afterExecute(Response response) {
        try {
            ResponseBody body = response.body();
            if (body == null) {
                return null;
            }
            return body.string();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Response executionMethod(String httpMethod, RequestParameter requestParameter, API api) throws SDKException {
        if ("POST".equals(httpMethod)) {
            Request request = this.buildPostRequest(requestParameter);
            return this.httpClient.send(request, api);
        }
        throw new SDKException(null, ErrorMessage.SDK_ERROR, "Call method is incorrect\uff1a" + httpMethod);
    }

    private Request buildPostRequest(RequestParameter requestParameter) {
        RequestBody requestBody;
        String url = requestParameter.getUrl();
        if (requestParameter.isHasFile()) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            Map<String, Object> objectMap = requestParameter.getData();
            for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof File) {
                    byte[] bytes;
                    File file = (File)value;
                    try {
                        bytes = Files.readAllBytes(file.toPath());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    builder.addFormDataPart(key, file.getName(), RequestBody.create(MediaType.parse("application/octet-stream"), bytes));
                    continue;
                }
                if (value == null) continue;
                builder.addFormDataPart(key, value.toString());
            }
            requestBody = builder.build();
        } else {
            FormBody.Builder builder = new FormBody.Builder();
            Map<String, Object> data = requestParameter.getData();
            if (!data.isEmpty()) {
                for (String key : data.keySet()) {
                    builder.add(key, String.valueOf(data.get(key)));
                }
            }
            requestBody = builder.build();
        }
        return new Request.Builder().url(url).headers(requestParameter.getHeaders()).post(requestBody).build();
    }

    private RequestParameter beforeExecute(API api) throws SDKException {
        String url = api.getUrl();
        Headers headers = this.buildHeaders(api);
        return new RequestParameter(url, headers, api.getAPIParams().toMapParams(), api.hasFile());
    }

    private Headers buildHeaders(API api) {
        Map<String, String> headers = api.getHeaders();
        return Headers.of(headers);
    }
}

