package com.mmc.iuav.user.entity.dronepilot;

import com.alibaba.fastjson2.annotation.JSONField;
import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.user.model.dto.dronepilot.PilotCertificationDTO;
import com.mmc.iuav.user.model.dto.dronepilot.PilotCertificationInteriorDTO;
import com.mmc.iuav.user.model.vo.dronepilot.PilotAbilityVO;
import com.mmc.iuav.user.model.vo.dronepilot.PilotCertificationVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/7/28 9:39
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PilotCertificationDO {


    @ApiModelProperty(value = "飞手执照id", example = "1")
    @NotNull(message = "飞手执照id不能为空", groups = Update.class)
    private Integer id;


    @ApiModelProperty(value = "执照类型 CAAC,UTC,OTHER(其他) 目前只有三种", example = "UTC", required = true)
    @NotNull(message = "执照类型不能为空", groups = {Create.class, Update.class})
    private String licenseType;


    @ApiModelProperty(value = "电子执照的编号", example = "231321312313211", required = true)
    @NotBlank(message = "电子执照的编号不能为空", groups = {Create.class, Update.class})
    private String licenseNumber;

    @ApiModelProperty(value = "上传执照", example = "http://share-fly.oss-cn-hangzhou.aliyuncs.com/file/2cbbeffb-c1d1-4b26-a9a9-9e17c85e35a9.jpg", required = true)
    @NotBlank(message = "上传执照的照片不能为空", groups = {Create.class, Update.class})
    private String licenseUrl;

    @ApiModelProperty(value = "地区编号不能为空", example = "100001", required = true)
    @NotNull(message = "地区编号不能为空", groups = {Create.class, Update.class})
    @Max(value = 80, message = "工作年限不能超过80年")
    private Integer areaNumber;

    @ApiModelProperty(value = "常驻城市不能为空", example = "深圳市", required = true)
    @NotBlank(message = "常驻城市不能为空", groups = {Create.class, Update.class})
    private String residentCity;

    @ApiModelProperty(value = "工作年限", example = "3", required = true)
    @NotNull(message = "工作年限不能为空", groups = {Create.class, Update.class})
    private Integer yearsOfWorking;

    @ApiModelProperty(value = "能力", required = true)
    @NotNull(message = "能力不能为空", groups = {Create.class, Update.class})
    private List<PilotAbilityVO> pilotAbility;

    @ApiModelProperty(value = "能力不能为空", example = "http://share-fly.oss-cn-hangzhou.aliyuncs.com/file/2cbbeffb-c1d1-4b26-a9a9-9e17c85e35a9.jpg", required = true)
    @NotBlank(message = "能力图片不能为空", groups = {Create.class, Update.class})
    private String abilityUrl;

    @ApiModelProperty(value = "个人简介", example = "无人机专业，工作三年", required = true)
    @NotBlank(message = "个人简介不能为空", groups = {Create.class, Update.class})
    @Size(max = 300, message = "个人不能超过300")
    private String individualResume;

    @ApiModelProperty(value = "备注", example = "航拍摄影,农业植保", required = false)
    private String remark;

    @ApiModelProperty(value = "审核是否通过 0审核中 1审核通过 2审核不通过", example = "0审核中 1审核通过 2审核不通过", required = false)
    private Integer auditStatus;

    @ApiModelProperty(value = "飞手是否同意加入飞手团队 0未操作 1飞手同意 2飞手不同意", example = "0审核中 1审核通过 2审核不通过", required = false)
    private Integer pilotStatus;

    @ApiModelProperty(value = "申请用户的id", example = "1")
    private Integer userAccountId;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date timeOfApplication;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    private String userName;

    private Date birthday;

    private Integer sex;

    private Integer age;

    private Integer reasonId;

    private String reason;

    /**
     * 申请飞手的手机号
     */
    private String phoneNum;

    @ApiModelProperty(value = "飞手头像", example = "http://")
    private String userImg;

    public PilotCertificationDO(PilotCertificationVO pilotCertificationVO, Integer userAccountId) {
        this.id = pilotCertificationVO.getId();
        this.licenseType = pilotCertificationVO.getLicenseType();
        this.licenseNumber = pilotCertificationVO.getLicenseNumber();
        this.licenseUrl = pilotCertificationVO.getLicenseUrl();
        this.areaNumber = pilotCertificationVO.getAreaNumber();
        this.residentCity = pilotCertificationVO.getResidentCity();
        this.yearsOfWorking = pilotCertificationVO.getYearsOfWorking();
        this.pilotAbility = pilotCertificationVO.getPilotAbility();
        this.abilityUrl = pilotCertificationVO.getAbilityUrl();
        this.individualResume = pilotCertificationVO.getIndividualResume();
        this.remark = pilotCertificationVO.getRemark();
        this.auditStatus = pilotCertificationVO.getAuditStatus();
        this.userAccountId = userAccountId;
    }


    public PilotCertificationDTO buildPilotCertificationDTO() {
        return PilotCertificationDTO.builder()
                .id(this.id)
                .licenseType(this.licenseType)
                .licenseUrl(this.licenseUrl)
                .licenseNumber(this.licenseNumber)
                .areaNumber(this.areaNumber)
                .residentCity(this.residentCity)
                .yearsOfWorking(this.yearsOfWorking)
                .pilotAbility(this.pilotAbility)
                .abilityUrl(this.abilityUrl)
                .individualResume(this.individualResume)
                .remark(this.remark)
                .auditStatus(this.auditStatus)
                .userAccountId(this.userAccountId)
                .timeOfApplication(this.timeOfApplication)
                .createTime(this.createTime)
                .updateTime(this.updateTime)
                .userName(this.userName)
                .age(this.age)
                .pilotStatus(this.pilotStatus)
                .sex(this.sex)
                .phoneNum(this.getPhoneNum())
                .reasonId(this.reasonId)
                .reason(this.reason)
                .userImg(this.userImg)
                .build();
    }


    public PilotCertificationInteriorDTO buildInterior() {
        return PilotCertificationInteriorDTO.builder()
                .id(this.id)
                .userAccountId(this.userAccountId)
                .build();
    }

}
