package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.MenuInfoDO;
import com.mmc.iuav.user.entity.RoleInfoDO;
import com.mmc.iuav.user.model.qo.RoleInfoQO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @Author small
 * @Date 2023/7/10 16:06
 * @Version 1.0
 */
@Mapper
public interface RoleDao {

    Integer countRoleName(String roleName);

    void insertRoleInfo(RoleInfoDO rd);

    void updateRoleInfo(RoleInfoDO rd);

    List<Integer> listUserRoleInfo(Integer id);

    void removeRoleInfo(Integer id);

    RoleInfoDO getRoleInfo(Integer id);

    int countPageRoleInfo(RoleInfoQO param);

    List<RoleInfoDO> listPageRoleInfo(RoleInfoQO param);

    Integer countRoleNameId(RoleInfoDO rd);

    Integer countNotDelUserAccountByRole(Integer id);

    String findList();

    List<MenuInfoDO> listRoleMenuInfo(Integer roleId);

    void batchAddMenuIds(Integer roleId, List<Integer> addMenuIds);

    void batchDeleteMenuIds(Integer roleId, List<Integer> deleteMenuIds);

    void updateUserRoleRel(Integer backUserAccountId, Integer roleId);

    void insertUserRoleRel(Integer backUserAccountId, Integer roleId);

    RoleInfoDO getRoleInfoByUserId(Integer backUserAccountId);
}

