package com.mmc.iuav.user.model.vo;

import com.mmc.iuav.group.Insert;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/5/16 13:56
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WebRegisterVO implements Serializable {
    private static final long serialVersionUID = 2500957724470423989L;
    @ApiModelProperty(value = "手机号")
    @NotNull(message = "手机号不能为空", groups = {Insert.class})
    private String phoneNum;
    @ApiModelProperty(value = "密码")
    @NotNull(message = "密码不能为空", groups = {Insert.class})
    private String password;
    @ApiModelProperty(value = "请求code")
    @NotNull(message = "验证码不能为空", groups = {Insert.class})
    private String code;
}
