package com.mmc.iuav.user.controller;

import com.mmc.iuav.general.CodeUtil;
import com.mmc.iuav.group.Insert;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.dao.UserServiceDao;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.qo.webLogin.LoginUserQO;
import com.mmc.iuav.user.model.vo.AppUserSucVO;
import com.mmc.iuav.user.model.vo.WebRegisterVO;
import com.mmc.iuav.user.model.vo.WxLoginVO;
import com.mmc.iuav.user.service.AuthService;
import com.mmc.iuav.user.service.UserAccountService;
import com.mmc.iuav.user.util.SmsUtil;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author: zj
 * @Date: 2023/5/15 15:50
 */
@Api(tags = "登录授权")
@RequestMapping("/auth/")
@RestController
public class AuthController {

    @Autowired
    private AuthService authService;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private UserServiceDao userServiceDao;
    @ApiOperation(value = "小程序登录/注册")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppUserSucVO.class)})
    @PostMapping("appletLogin")
    public ResultBody appletLogin(@Validated(value = {Insert.class}) @RequestBody WxLoginVO wxLoginVO) {
        return authService.appletLogin(wxLoginVO);
    }

    @ApiOperation(value = "平台账号密码登录")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LoginSuccessDTO.class)})
    @PostMapping("backEndLogin")
    public ResultBody backEndLogin(
            @ApiParam(value = "账号登录QO", required = true) @Validated @RequestBody LoginUserQO param) {
        return authService.backEndLogin(param);
    }

    @ApiOperation(value = "测试-小程序unionId登录/注册")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppUserSucVO.class)})
    @PostMapping("testAppletLogin")
    public ResultBody testAppletLogin(@RequestParam String unionId) {
        return authService.testAppletLogin(unionId);
    }

    @ApiOperation(value = "测试-手机号登录")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppUserSucVO.class)})
    @GetMapping("testPhoneLogin")
    public ResultBody testPhoneLogin(@RequestParam String phone) {
        String unionId = userAccountService.selectUnionIdByPhone(phone);
        return authService.testAppletLogin(unionId);
    }

    @ApiOperation(value = "web注册获取手机号验证码")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("getVerifyCode")
    public ResultBody getVerifyCode(@RequestParam(value = "phoneNum") String phoneNum) {
        if(phoneNum == null){
            return ResultBody.error("手机号不能为空");
        }
        // 根据手机号生成验证码
        String verifyCode = CodeUtil.getRandomNum(6);
        // 发送给用户
        SmsUtil.verifyCode(verifyCode, phoneNum);
        Map<String, String> redisData = new HashMap<>();
        redisData.put("phoneNum", phoneNum);
        redisData.put("verifyCode", verifyCode);
        stringRedisTemplate.opsForHash().putAll(verifyCode + phoneNum, redisData);
        stringRedisTemplate.expire(verifyCode + phoneNum, 1000, TimeUnit.SECONDS);
        return ResultBody.success();
    }
    @ApiOperation(value = "web端注册")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppUserSucVO.class)})
    @PostMapping("webRegister")
    public ResultBody webRegister(@Validated(value = {Insert.class}) @RequestBody WebRegisterVO webRegisterVO) {
        return authService.webRegister(webRegisterVO);
    }
    @ApiOperation(value = "web端账号密码登录")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LoginSuccessDTO.class)})
    @PostMapping("webLogin")
    public ResultBody webLogin(
            @ApiParam(value = "账号登录QO", required = true) @Validated @RequestBody LoginUserQO param) {
        return authService.webLogin(param);

    }

    @ApiOperation(value = "web找回密码")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LoginSuccessDTO.class)})
    @PostMapping("findPassword")
    public ResultBody updatePassword(@RequestBody WebRegisterVO webRegisterVO) {
        return authService.updatePassword(webRegisterVO);
    }
}
