package com.mmc.iuav.user.entity;

import com.alibaba.fastjson2.annotation.JSONField;
import com.mmc.iuav.user.model.dto.RoleInfoDTO;
import com.mmc.iuav.user.model.vo.RoleInfoVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/7/10 16:07
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class RoleInfoDO {
    private static final long serialVersionUID = -9173631450897624325L;
    private Integer id;
    /**
     * 角色编号
     */
    private String roleNo;
    /**
     * 角色名称
     */
    private String roleName;
    /**
     * 是否删除
     */
    private Integer isDeleted;

    /**
     * 备注
     */
    private String remark;
    /**
     * 创建时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
     * 更新时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    /**
     * 创建角色账号id
     */
    private Integer userAccountId;
    /**
     * 账号名称
     */
    private String userName;

    /**
     * 角色关联账号表
     */
    List<UserRoleRel> userRoleRelList;


    /**
     * 角色关联菜单
     */
    List<MenuInfoDO> menuInfoDOList;

    /**
     * DTO转换
     *
     * @return
     */
    public RoleInfoDTO buildRoleInfoDTO() {
        return RoleInfoDTO.builder().id(this.id).roleNo(this.roleNo).roleName(this.roleName)
                .userName(this.userName)
                .remark(this.remark).build();
    }

    /**
     * VO类转换
     */
    public RoleInfoDO(RoleInfoVO role) {
        this.id = role.getId();
        this.roleName = role.getRoleName();
        this.remark = role.getRemark();
    }
}

