package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Page;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.RoleInfoDTO;
import com.mmc.iuav.user.model.qo.RoleInfoQO;
import com.mmc.iuav.user.model.vo.RoleInfoVO;
import com.mmc.iuav.user.service.RoleService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author small
 * @Date 2023/7/7 17:53
 * @Version 1.0
 */
@Api(tags = "角色管理")
@RequestMapping("/role")
@RestController
public class RoleController extends BaseController {


    @Autowired
    private RoleService roleService;


    @ApiOperation(value = "角色管理-新增")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insertRoleInfo")
    public ResultBody insertRoleInfo(HttpServletRequest request, @RequestBody @Validated(value = {Create.class}) RoleInfoVO role) {
        return roleService.insertRoleInfo(role, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "角色管理-修改")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updateRoleInfo")
    public ResultBody updateRoleInfo(HttpServletRequest request, @RequestBody @Validated(value = {Update.class}) RoleInfoVO role) {
        return roleService.updateRoleInfo(role, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "角色管理-删除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("removeRoleInfo")
    public ResultBody removeRoleInfo(@ApiParam(value = "角色id", required = true) @RequestParam Integer id) {
        return roleService.removeRoleInfo(id);
    }


    @ApiOperation(value = "角色管理-分页")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RoleInfoDTO.class)})
    @PostMapping("listRoleInfoPage")
    public ResultBody<RoleInfoDTO> listRoleInfoPage(HttpServletRequest request,
                                                    @Validated(value = {Page.class}) @ApiParam(value = "角色查询QO", required = true) @RequestBody RoleInfoQO param) {
        return ResultBody.success(roleService.listPageRoleInfo(param, this.getUserLoginInfoFromRedis(request)));
    }


}
