package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.vo.CompanyAuthVO;
import com.mmc.iuav.user.model.vo.CooperationTagVO;
import com.mmc.iuav.user.model.vo.UserApplyTagVO;
import com.mmc.iuav.user.service.CooperationService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/17 21:17
 */
@Api(tags = "合作加盟")
@RequestMapping("/cooperation/")
@RestController
public class CooperationController extends BaseController{
    @Autowired
    private CooperationService cooperationService;

    @ApiOperation(value = "加盟标签列表")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = CooperationTagVO.class) })
    @GetMapping("listTag")
    public ResultBody listTag() {
        return cooperationService.listTag();
    }

    @ApiOperation(value = "根据id获取标签信息")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = CooperationTagVO.class) })
    @GetMapping("getTagById")
    public ResultBody getTagById(@RequestParam("id") Integer id) {
        return cooperationService.getTagById(id);
    }

    @ApiOperation(value = "申请加盟")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("apply")
    public ResultBody apply(@Validated(value = {Insert.class})@RequestBody UserApplyTagVO userApplyTagVO, HttpServletRequest request){
        Integer userAccountId  = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        userApplyTagVO.setUserAccountId(userAccountId);
        return cooperationService.apply(userApplyTagVO);
    }

    @ApiOperation(value = "后台设置小程序用户标签")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("changeUserTag")
    public ResultBody changeUserTag(@RequestParam("userAccountId") Integer userAccountId, @RequestParam("cooperationTagId") Integer cooperationTagId) {
        return cooperationService.changeUserTag(userAccountId, cooperationTagId);
    }
}
