package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.dto.UserAccountSimpleDTO;
import com.mmc.iuav.user.model.vo.BUserAccountVO;
import com.mmc.iuav.user.model.vo.UserAccountVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/16 17:00
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserAccountDO implements Serializable {
    private static final long serialVersionUID = 5007589179946146721L;
    private Integer id;
    private String accountNo;
    private Integer accountType;
    private String password;
    private String uid;
    private String phoneNum;
    private String userName;
    private String nickName;
    private String userImg;
    private String openId;
    private String unionId;
    private Integer userSex;
    private String email;
    private Integer source;
    private Integer accountStatus;
    private String remark;
    private Integer portType;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;
    private Integer provinceCode;
    private Integer cityCode;
    private Integer districtCode;

    private Integer cooperationTagId;
    private Integer companyAuthStatus;

    public UserAccountDO(UserAccountVO userAccountVO) {
        this.id = userAccountVO.getId();
        this.phoneNum = userAccountVO.getPhoneNum();
        this.userName = userAccountVO.getUserName();
        this.nickName = userAccountVO.getNickName();
        this.userImg = userAccountVO.getUserImg();
        this.userSex = userAccountVO.getUserSex();
        this.email = userAccountVO.getEmail();
        this.accountStatus = userAccountVO.getAccountStatus();
        this.remark = userAccountVO.getRemark();
        this.portType = userAccountVO.getPortType();
    }

    public UserAccountDO(BUserAccountVO bUserAccountVO) {
        this.id = bUserAccountVO.getId();
        this.accountNo = bUserAccountVO.getAccountNo();
        this.phoneNum = bUserAccountVO.getPhoneNum();
        this.userName = bUserAccountVO.getUserName();
        this.email = bUserAccountVO.getEmail();
        this.accountStatus = bUserAccountVO.getAccountStatus();
        this.remark = bUserAccountVO.getRemark();
        this.provinceCode = bUserAccountVO.getProvinceCode();
        this.cityCode = bUserAccountVO.getCityCode();
        this.districtCode = bUserAccountVO.getDistrictCode();
    }

    public UserAccountVO buildUserAccountVO() {
        return UserAccountVO.builder().id(this.id).uid(this.uid).accountNo(this.accountNo).accountType(this.accountType).phoneNum(this.phoneNum).userName(this.userName).nickName(this.nickName)
                .userImg(this.userImg).userSex(this.userSex).email(this.email).source(this.source).accountStatus(this.accountStatus).remark(this.remark).portType(this.portType)
                .createTime(this.createTime).companyAuthStatus(this.companyAuthStatus).cooperationTagId(this.cooperationTagId).build();
    }

    public UserAccountSimpleDTO buildUserAccountSimpleDTO() {
        return UserAccountSimpleDTO.builder().id(this.id).uid(this.uid).accountNo(this.accountNo).accountType(this.accountType).phoneNum(this.phoneNum).userName(this.userName).nickName(this.nickName)
              .userImg(this.userImg).userSex(this.userSex).email(this.email).source(this.source).accountStatus(this.accountStatus).portType(this.portType)
                .companyAuthStatus(this.companyAuthStatus == null || this.companyAuthStatus != 1 ? 0 : 1).cooperationTagId(this.cooperationTagId)
              .build();
    }
}
