package com.mmc.iuav.user.entity;

import com.alibaba.fastjson2.annotation.JSONField;
import com.mmc.iuav.user.model.vo.UserMessageVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author han
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class UserMessageLogDO implements Serializable {
    private static final long serialVersionUID = 973044768156590099L;
    /**
     * 消息记录ID
     */
    private Integer id;

    /**
     * 发送方
     */
    private Integer senderUserId;

    /**
     * 接收方
     */
    private Integer receiverUserId;

    /**
     * 新消息数量
     */
    private Integer messageCount;
    /**
     * 创建时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date newTime;

}
