package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.vo.ApplyTagEditVO;
import com.mmc.iuav.user.model.vo.CompanyAuthVO;
import com.mmc.iuav.user.model.vo.CompanyInfoVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/7/3 15:56
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CompanyInfoDO implements Serializable {
    private static final long serialVersionUID = -533935402556556571L;
    private Integer id;
    private Integer companyType;
    private String companyName;
    private String fullName;
    private String province;
    private String city;
    private String district;
    private String address;
    private String companyUserName;
    private String phoneNum;
    private String remark;
    private Integer backUserAccountId;
    private Double lat;
    private Double lon;
    private String creditCode;
    private String licenseImg;
    private String backImg;
    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;

    @ApiModelProperty(value = "品牌名称", example = "科比特")
    private String brandName;

    @ApiModelProperty(value = "品牌logo", example = "http://")
    private String brandLogo;
    @ApiModelProperty(value = "服务资质信息", example = "5星店铺")
    private String content;
    @ApiModelProperty(value = "评分", example = "*****")
    private Integer score;

    private Integer leader;

    public CompanyInfoDO(ApplyTagEditVO applyTagEditVO) {
        this.address = applyTagEditVO.getAddress();
        this.lon = applyTagEditVO.getLon();
        this.lat = applyTagEditVO.getLat();
        this.content = applyTagEditVO.getContent();
        this.score = applyTagEditVO.getScore();
    }

    public CompanyInfoVO buildCompanyInfoVO() {
        return CompanyInfoVO.builder().id(id).companyType(companyType).companyName(companyName).fullName(fullName).province(province)
                .brandName(brandName)
                .brandLogo(brandLogo)
                .userAccountId(userAccountId)
                .lon(this.lon).lat(this.lat).creditCode(this.creditCode).licenseImg(this.licenseImg).leader(this.leader)
                .city(city).district(district).address(address).companyUserName(companyUserName).phoneNum(phoneNum).remark(remark)
                .content(this.getContent())
                .score(this.getScore())
                .backImg(this.backImg)
                .build();
    }

    public CompanyAuthVO buildCompanyAuthVO() {
        return CompanyAuthVO.builder().id(this.id).companyName(this.companyName).creditCode(this.creditCode).licenseImg(this.licenseImg).build();
    }

    public CompanyInfoDO(CompanyInfoVO companyInfo) {
        this.id = companyInfo.getId();
        this.companyType = companyInfo.getCompanyType();
        this.companyName = companyInfo.getCompanyName();
        this.fullName = companyInfo.getFullName();
        this.province = companyInfo.getProvince();
        this.city = companyInfo.getCity();
        this.district = companyInfo.getDistrict();
        this.address = companyInfo.getAddress();
        this.companyUserName = companyInfo.getCompanyUserName();
        this.phoneNum = companyInfo.getPhoneNum();
        this.remark = companyInfo.getRemark();
        this.userAccountId = companyInfo.getUserAccountId();
        this.brandName = companyInfo.getBrandName();
        this.brandLogo = companyInfo.getBrandLogo();
        this.lon = companyInfo.getLon();
        this.lat = companyInfo.getLat();
        this.content = companyInfo.getContent();
        this.score = companyInfo.getScore();
        this.backImg = companyInfo.getBackImg();
    }
}
