package com.mmc.iuav.user.service.fdd.impl;

import com.alibaba.fastjson2.JSONObject;
import com.fadada.sdk.base.client.FddBaseClient;
import com.fadada.sdk.base.model.req.AddSignatureParams;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import com.mmc.iuav.user.constant.fdd.FddConnectConstant;
import com.mmc.iuav.user.constant.fdd.FddConstant;
import com.mmc.iuav.user.dao.UserServiceDao;
import com.mmc.iuav.user.dao.fdd.SealManageDao;
import com.mmc.iuav.user.dao.fdd.UserFddAuthDao;
import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.entity.fdd.SealInfoDO;
import com.mmc.iuav.user.entity.fdd.UserFddDO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.fdd.vo.SealVO;
import com.mmc.iuav.user.service.fdd.SealManageService;
import com.mmc.iuav.user.service.fdd.UserFddAuthService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2022/8/31 17:29
 * 概要：
 */
@Service
public class SealManageServiceImpl implements SealManageService {
    @Resource
    UserServiceDao userServiceDao;
    @Resource
    UserFddAuthService userFddAuthService;
    @Resource
    UserFddAuthDao userFddAuthDao;
    @Resource
    SealManageDao sealManageDao;

    @Override
    public ResultBody uploadSeal(SealVO sealVO, LoginSuccessDTO loginSuccessDTO) {
        // 判断当前用户是那个端口进来的用户，根据不同端口用户设置不同的unionId
        if (sealVO.getPort().equals(0)) {
            UserAccountDO userInfo = userServiceDao.getUserAccountById(loginSuccessDTO.getUserAccountId());
            String uid = userFddAuthService.replaceUnableString(userInfo.getUnionId());
            sealVO.setUnionId(uid);
        } else {
            sealVO.setUnionId(loginSuccessDTO.getUserAccountId().toString());
        }
        // 获取用户法大大的（实名/企业）认证信息
        UserFddDO userFddInfo = userFddAuthDao.getAppUserFddInfo(sealVO.getUnionId());
        if (userFddInfo == null) {
            return ResultBody.error(ResultEnum.BUSINESS_LICENSE_CHECK_ERROR);
        } else if (!userFddInfo.getPersonVerifyStatus().equals(2) || !userFddInfo.getEntVerifyStatus().equals(4)) {
            return ResultBody.error(ResultEnum.BUSINESS_LICENSE_CHECK_NOT_PASS);
        }
        FddBaseClient baseClient = new FddBaseClient(FddConnectConstant.APP_ID, FddConnectConstant.APP_KEY, FddConnectConstant.VERSION, FddConnectConstant.HOST);
        AddSignatureParams params = new AddSignatureParams();
        //客户编号
        params.setCustomerId(userFddInfo.getCustomerId());
        //下面章图片base64、签章图片、图片公网地址三选一
//        params.setSignatureImgBase64(""); //签章图片base64
//        params.setFile(new File("D:\\sign.png")); //签章图片
        //签章图片公网地址
        params.setImgUrl(sealVO.getSealUrl());
        String result = baseClient.invokeAddSignature(params);
        if (!JSONObject.parseObject(result).getString(FddConstant.CODE).equals(FddConstant.SUCCESS)) {
            return ResultBody.error(JSONObject.parseObject(result).getString(FddConstant.MSG));
        } else {
            // 获取返回的印章编号
            String dataStr = JSONObject.parseObject(result).getString(FddConstant.DATA);
            String signatureId = JSONObject.parseObject(dataStr).getString(FddConstant.SIGNATURE_ID);
            SealInfoDO sealInfoDO = new SealInfoDO();
            sealInfoDO.setSealName(sealVO.getSealName());
            sealInfoDO.setSignatureId(signatureId);
            sealInfoDO.setUnionId(sealVO.getUnionId());
            sealInfoDO.setSealStatus(sealVO.getSealStatus());
            sealInfoDO.setSealUrl(sealVO.getSealUrl());
            // 新增印章信息
            sealManageDao.insertSealInfo(sealInfoDO);
            return ResultBody.success();
        }
    }
}
