package com.mmc.iuav.user.controller.fdd;

/**
 * @Author LW
 * @date 2022/8/31 15:28
 * 概要：
 */

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.fdd.vo.SealVO;
import com.mmc.iuav.user.service.fdd.SealManageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 * @date 2022/8/3 10:22
 * 概要：
 */
@Api(tags = {"无人机城--印章管理模块-接口" })
@RequestMapping("/seal/")
@RestController
public class SealManageController extends BaseController {

    @Autowired
    private SealManageService sealManageService;

    @ApiOperation(value = "上传印章")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/uploadSeal")
    public ResultBody uploadSeal(@RequestBody SealVO sealVO, HttpServletRequest request) {
        return sealManageService.uploadSeal(sealVO, this.getUserLoginInfoFromRedis(request));
    }

//    @ApiOperation(value = "当前用户印章列表")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = SealInfoDTO.class)})
//    @PostMapping("/getSealInfoList")
//    public ResultBody getSealInfoList(HttpServletRequest request, @RequestBody SealInfoVO param) {
//        return ResultBody.success(uavAppSealManageService.getSealInfoList(this.getCurrentAccount(request).getId(), param));
//    }
//
//    @ApiOperation(value = "删除印章")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    @GetMapping("/removeSeal")
//    public ResultBody removeSeal(@ApiParam(value = "印章编号") @RequestParam(value = "signatureId") String signatureId,
//                                 HttpServletRequest request,
//                                 @ApiParam(value = "小程序用户unionId") @RequestParam(value = "unionId", required = false) String unionId
//    ) {
//        return uavAppSealManageService.removeSeal(signatureId, unionId, this.getCurrentAccount(request).getId());
//    }
//
//    @ApiOperation(value = "设置默认签章")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    @GetMapping("/defaultSeal")
//    public ResultBody defaultSeal(@ApiParam(value = "印章编号") @RequestParam(value = "signatureId") String signatureId, HttpServletRequest request,
//                                  @ApiParam(value = "小程序用户unionId") @RequestParam(value = "unionId", required = false) String unionId) {
//        return uavAppSealManageService.defaultSeal(signatureId, this.getCurrentAccount(request).getId(), unionId);
//    }
//
//    @ApiOperation(value = "替换印章图片")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    @PostMapping("/replaceSealImg")
//    public ResultBody replaceSealImg(@RequestBody UavSealInfoVO param, HttpServletRequest request) throws Exception {
//        return uavAppSealManageService.replaceSealImg(param, this.getCurrentAccount(request).getId());
//    }
//
//    @ApiOperation(value = "查看印章信息")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    @GetMapping("/getSealInfo")
//    public ResultBody getSealInfo(@ApiParam(value = "印章编号") @RequestParam(value = "signatureId") String signatureId, HttpServletRequest request) {
//        return uavAppSealManageService.getSealInfo(signatureId, this.getCurrentAccount(request).getId());
//    }
}
