package com.mmc.iuav.user.client;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.vo.WalletUsersVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * @author: zj
 * @Date: 2023/6/8 15:16
 */
@Component
public class PayClient {

    @Value("${iuav.pay.uri}")
    private String payAppUri;

    @Autowired
    private RestTemplate restTemplate;

    public ResultBody createWallet(Integer userAccountId){
        WalletUsersVO walletUsersVO = new WalletUsersVO();
        walletUsersVO.setRepoAccountId(userAccountId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(walletUsersVO), headers);
        ResponseEntity<ResultBody> responseEntity = restTemplate.exchange(payAppUri + "/payment/repocash/walletUsers", HttpMethod.POST, entity, ResultBody.class);
        return responseEntity.getBody();
    }
}
