package com.mmc.iuav.user.entity.wallet;

import com.mmc.iuav.user.enums.WithdrawalMethod;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * (WithdrawalLogDO)实体类
 *
 * @author makejava
 * @since 2023-08-25 16:57:13
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class WithdrawalLogDO implements Serializable {
    private static final long serialVersionUID = 757884073681912750L;

    private Integer id;
    /**
     * 用户id
     */
    private Integer userAccountId;
    /**
     * 支付流水号(T202109031615XXXX)XXXX随机数
     */
    private String payNo;
    /**
     * 150:提现冻结  200:提现成功 250:提现失败
     */
    private Integer payMethod;
    /**
     * 流水时间
     */
    private Date payTime;
    /**
     * 提现申请id
     */
    private Integer xzWithdrawalApplyId;

    private String typeName;

    /**
     * 提现冻结
     */
    private BigDecimal salaryFreeze;

    private BigDecimal salaryPaid;

    private Date createTime;

    private Date updateTime;

    public UserBillingDetailVO buildUserBillingDetailVO() {
        if (payMethod.equals(WithdrawalMethod.TXDJ.getCode())) {
            this.typeName = WithdrawalMethod.TXDJ.getName();
        }
        if (payMethod.equals(WithdrawalMethod.TXCG.getCode())) {
            this.typeName = WithdrawalMethod.TXCG.getName();
        }
        if (payMethod.equals(WithdrawalMethod.TXSB.getCode())) {
            this.typeName = WithdrawalMethod.TXSB.getName();
        }
        return UserBillingDetailVO.builder().id(id).userAccountId(userAccountId)
                .payMethod(payMethod).payTime(payTime).payNo(payNo).name(typeName).build();
    }
}

