package com.mmc.iuav.response;

/**
 * @author: zj
 * @Date: 2023/5/16 10:41
 */
public enum ResultEnum implements BaseErrorInfoInterface{
    SUCCESS("200", "success"),
    FAIL("500", "fail"),
    PARAM_ERROR("400", "参数错误"),

    //企业认证
    BUSINESS_LICENSE_CHECK_ANALYSIS_ERROR("1000", "营业执照解析失败，请上传有效清晰的执照"),
    COMPANY_NOT_AUTH_ERROR("1001", "未进行企业认证"),
    BUSINESS_LICENSE_CHECK_PARAMETER_ERROR("1002", "企业信息与营业执照信息不一致，请重新上传"),

    //微信相关
    WX_ACCESS_TOKEN_ERROR("5027", "获取微信AccessToken失败"),
    APPLET_QR_CODE_CREATE_ERROR("5030", "生成小程序码错误："),

    APPLET_PORT_TYPE_ERROR("7001", "小程序端口类型错误"),
    APPLET_LOGIN_ERROR("7002", "获取小程序登录失败");

    /**
     * 错误码
     *
     * @return
     */
    String resultCode;

    /**
     * 错误描述
     *
     * @return
     */
    String resultMsg;

    ResultEnum(String resultCode, String resultMsg) {
        this.resultCode = resultCode;
        this.resultMsg = resultMsg;
    }

    @Override
    public String getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getResultMsg() {
        return this.resultMsg;
    }
}
